\name{SignedDanielssonDistanceMapImageFilter}
\alias{SignedDanielssonDistanceMapImageFilter}
\title{SignedDanielssonDistanceMapImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter computes the signed distance map of the input image as an
approximation with pixel accuracy to the Euclidean distance.
SignedDanielssonDistanceMapImageFilter}
\details{
This class is parameterized over the type of the input image and the
type of the output image.
For purposes of evaluating the signed distance map, the input is
assumed to be binary composed of pixels with value 0 and non-zero.
The inside is considered as having negative distances. Outside is
treated as having positive distances. To change the convention, use
the InsideIsPositive(bool) function.
As a convention, the distance is evaluated from the boundary of the ON
pixels.
The filter returns
A signed distance map with the approximation to the euclidean
distance.
A voronoi partition. (See itkDanielssonDistanceMapImageFilter)
A vector map containing the component of the vector relating the
current pixel with the closest point of the closest object to this
pixel. Given that the components of the distance are computed in
"pixels", the vector is represented by an itk::Offset . That is, physical coordinates are not used. (See
itkDanielssonDistanceMapImageFilter)
 This filter internally uses the DanielssonDistanceMap filter. This
filter is N-dimensional.
See:
itkDanielssonDistanceMapImageFilter
SignedDanielssonDistanceMap for the procedural interface
itk::SignedDanielssonDistanceMapImageFilter for the Doxygen on the original ITK class.
SignedDanielssonDistanceMapImageFilter}
%C++ includes: sitkSignedDanielssonDistanceMapImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{bool GetInsideIsPositive() const:}{
Get if the inside represents positive values in the signed distance
map. See GetInsideIsPositive()
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetSquaredDistance() const:}{
Get the distance squared.
}
\item{bool GetUseImageSpacing() const:}{
Get whether spacing is used.
}
\item{Image GetVectorDistanceMap() const:}{
Get vector field of distances.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{Image GetVoronoiMap() const:}{
Get Voronoi Map This map shows for each pixel what object is closest
to it. Each object should be labeled by a number (larger than 0), so
the map has a value for each pixel corresponding to the label of the
closest object.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{Self InsideIsPositiveOff():}{}
\item{Self InsideIsPositiveOn():}{
Set the value of InsideIsPositive to true or false respectfully.
}
\item{Self SetInsideIsPositive(bool InsideIsPositive):}{
Set if the inside represents positive values in the signed distance
map. By convention ON pixels are treated as inside pixels.
}
\item{Self SetSquaredDistance(bool SquaredDistance):}{
Set if the distance should be squared.
}
\item{Self SetUseImageSpacing(bool UseImageSpacing):}{
Set if image spacing should be used in computing distances.
}
\item{ SignedDanielssonDistanceMapImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SquaredDistanceOff():}{}
\item{Self SquaredDistanceOn():}{
Set the value of SquaredDistance to true or false respectfully.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageSpacingOff():}{}
\item{Self UseImageSpacingOn():}{
Set the value of UseImageSpacing to true or false respectfully.
}
\item{ ~SignedDanielssonDistanceMapImageFilter():}{
Destructor
}
}
}
