/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.credentials.Credentials;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.collaboration.auth.services.OAuthRequest;
import com.intellij.collaboration.auth.services.OAuthServiceBase;
import com.intellij.collaboration.auth.services.PkceUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.plugins.github.authentication.GHOAuthCredentialsAcquirer;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthService;", "Lcom/intellij/collaboration/auth/services/OAuthServiceBase;", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "authorize", "Ljava/util/concurrent/CompletableFuture;", "revokeToken", "", "token", "GHOAuthRequest", "Companion", "intellij.vcs.github"})
public final class GHOAuthService
extends OAuthServiceBase<Credentials> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SERVICE_NAME = "github/oauth";
    @NotNull
    private static final Url SERVICE_URL = Urls.newFromEncoded((String)"https://account.jetbrains.com/github/oauth/intellij");

    @NotNull
    public String getName() {
        return SERVICE_NAME;
    }

    @NotNull
    public final CompletableFuture<Credentials> authorize() {
        return this.authorize(new GHOAuthRequest());
    }

    public void revokeToken(@NotNull String token2) {
        Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthService$Companion;", "", "<init>", "()V", "SERVICE_NAME", "", "instance", "Lorg/jetbrains/plugins/github/authentication/GHOAuthService;", "getInstance", "()Lorg/jetbrains/plugins/github/authentication/GHOAuthService;", "SERVICE_URL", "Lcom/intellij/util/Url;", "getSERVICE_URL", "()Lcom/intellij/util/Url;", "intellij.vcs.github"})
    @SourceDebugExtension(value={"SMAP\nGHOAuthService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHOAuthService.kt\norg/jetbrains/plugins/github/authentication/GHOAuthService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,62:1\n42#2,3:63\n*S KotlinDebug\n*F\n+ 1 GHOAuthService.kt\norg/jetbrains/plugins/github/authentication/GHOAuthService$Companion\n*L\n57#1:63,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GHOAuthService getInstance() {
            boolean $i$f$service = false;
            Class<GHOAuthService> serviceClass$iv = GHOAuthService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (GHOAuthService)((Object)object);
        }

        @NotNull
        public final Url getSERVICE_URL() {
            return SERVICE_URL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthService$GHOAuthRequest;", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "<init>", "()V", "port", "", "getPort", "()I", "codeVerifier", "", "codeChallenge", "authorizationCodeUrl", "Lcom/intellij/util/Url;", "getAuthorizationCodeUrl", "()Lcom/intellij/util/Url;", "credentialsAcquirer", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "getCredentialsAcquirer", "()Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "authUrlWithParameters", "getAuthUrlWithParameters", "Companion", "intellij.vcs.github"})
    private static final class GHOAuthRequest
    implements OAuthRequest<Credentials> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String codeVerifier = PkceUtils.INSTANCE.generateCodeVerifier();
        @NotNull
        private final String codeChallenge;
        @NotNull
        private final OAuthCredentialsAcquirer<Credentials> credentialsAcquirer;
        @NotNull
        private final Url authUrlWithParameters;

        public GHOAuthRequest() {
            Base64.Encoder encoder = Base64.getEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)encoder, (String)"getEncoder(...)");
            this.codeChallenge = PkceUtils.INSTANCE.generateShaCodeChallenge(this.codeVerifier, encoder);
            this.credentialsAcquirer = new GHOAuthCredentialsAcquirer(this.codeVerifier);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"code_challenge", (Object)this.codeChallenge), TuplesKt.to((Object)"callback_url", (Object)this.getAuthorizationCodeUrl().toExternalForm())};
            Url url = GHOAuthRequest.Companion.getAUTHORIZE_URL().addParameters(MapsKt.mapOf((Pair[])pairArray));
            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
            this.authUrlWithParameters = url;
        }

        private final int getPort() {
            return BuiltInServerManager.Companion.getInstance().getPort();
        }

        @NotNull
        public Url getAuthorizationCodeUrl() {
            return Urls.newFromEncoded((String)("http://127.0.0.1:" + this.getPort() + "/api/github/oauth/authorization_code"));
        }

        @NotNull
        public OAuthCredentialsAcquirer<Credentials> getCredentialsAcquirer() {
            return this.credentialsAcquirer;
        }

        @NotNull
        public Url getAuthUrlWithParameters() {
            return this.authUrlWithParameters;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthService$GHOAuthRequest$Companion;", "", "<init>", "()V", "AUTHORIZE_URL", "Lcom/intellij/util/Url;", "getAUTHORIZE_URL", "()Lcom/intellij/util/Url;", "intellij.vcs.github"})
        public static final class Companion {
            private Companion() {
            }

            private final Url getAUTHORIZE_URL() {
                Url url = GHOAuthService.Companion.getSERVICE_URL().resolve("authorize");
                Intrinsics.checkNotNullExpressionValue((Object)url, (String)"resolve(...)");
                return url;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

