/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.editorconfig.language.util.core.EditorConfigPsiTreeUtilCore;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0015\u0010\u000b\u001a\u00070\u0005\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/editorconfig/language/util/EditorConfigPresentationUtil;", "", "<init>", "()V", "getFileName", "", "file", "Lcom/intellij/psi/PsiFile;", "withFolder", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Lorg/jetbrains/annotations/NonNls;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.editorconfig.backend"})
@SourceDebugExtension(value={"SMAP\nEditorConfigPresentationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigPresentationUtil.kt\norg/editorconfig/language/util/EditorConfigPresentationUtil\n+ 2 EditorConfigPsiTreeUtil.kt\norg/editorconfig/language/util/EditorConfigPsiTreeUtil\n*L\n1#1,28:1\n192#2:29\n*S KotlinDebug\n*F\n+ 1 EditorConfigPresentationUtil.kt\norg/editorconfig/language/util/EditorConfigPresentationUtil\n*L\n26#1:29\n*E\n"})
public final class EditorConfigPresentationUtil {
    @NotNull
    public static final EditorConfigPresentationUtil INSTANCE = new EditorConfigPresentationUtil();

    private EditorConfigPresentationUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String getFileName(@NotNull PsiFile file, boolean withFolder) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return EditorConfigPresentationUtil.getFileName(virtualFile, withFolder);
    }

    @JvmStatic
    @NlsSafe
    @NotNull
    public static final String getFileName(@NotNull VirtualFile file, boolean withFolder) {
        Object object;
        boolean settingsAwareFlag;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        UISettings settings = UISettings.Companion.getInstanceOrNull();
        UISettings uISettings = settings;
        boolean bl = uISettings != null && (uISettings = uISettings.getState()) != null ? uISettings.getShowDirectoryForNonUniqueFilenames() & withFolder : (settingsAwareFlag = withFolder);
        if (settingsAwareFlag) {
            VirtualFile virtualFile = file.getParent();
            object = (virtualFile != null ? virtualFile.getName() : null) + "/" + file.getName();
        } else {
            String string = file.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final String path(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        EditorConfigPsiTreeUtil editorConfigPsiTreeUtil = EditorConfigPsiTreeUtil.INSTANCE;
        PsiFile file$iv = element.getContainingFile();
        boolean $i$f$getOriginalFile = false;
        Object object = EditorConfigPsiTreeUtilCore.INSTANCE.getOriginalFile(file$iv, Reflection.getOrCreateKotlinClass(PsiFile.class));
        if (object == null || (object = object.getVirtualFile()) == null || (object = object.getParent()) == null || (object = object.getPath()) == null) {
            object = "";
        }
        return object;
    }
}

