/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class BiLinkedHashMultiMap<K extends Comparable<K>, V> {
    private LinkedHashMap<K, LinkedList<V>> multiMapKeyToValues = new LinkedHashMap();
    private LinkedHashMap<V, K> hashMapValuesToKey = new LinkedHashMap();

    public void putAll(K key, List<V> values) {
        for (V value : values) {
            this.put(key, value);
        }
    }

    public void put(K key, V value) {
        LinkedList<Object> values;
        Comparable oldKey = (Comparable)this.hashMapValuesToKey.get(value);
        if (oldKey != null) {
            values = this.multiMapKeyToValues.get(oldKey);
            values.remove(value);
        }
        if ((values = this.multiMapKeyToValues.get(key)) == null) {
            values = new LinkedList();
            this.multiMapKeyToValues.put(key, values);
        }
        values.add(value);
        this.hashMapValuesToKey.put(value, key);
    }

    public K getKey(V value) {
        return (K)((Comparable)this.hashMapValuesToKey.get(value));
    }

    public LinkedList<V> getValues(K key) {
        LinkedList<Object> toReturn = this.multiMapKeyToValues.get(key);
        if (toReturn == null) {
            toReturn = new LinkedList();
        }
        return toReturn;
    }

    public Set<K> keySet() {
        return this.multiMapKeyToValues.keySet();
    }

    public boolean isMaximalKey(K key) {
        for (Comparable otherKey : this.multiMapKeyToValues.keySet()) {
            if (key.compareTo((Comparable)otherKey) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isMinimalKey(K key) {
        for (Comparable otherKey : this.multiMapKeyToValues.keySet()) {
            if (key.compareTo((Comparable)otherKey) <= 0) continue;
            return false;
        }
        return true;
    }
}

