/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.windowsdot;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sourceforge.plantuml.brotli.BrotliInputStream;
import net.sourceforge.plantuml.log.Logme;

public final class WindowsDotArchive {
    private static WindowsDotArchive singleton = null;
    private Boolean isThereArchive;
    private File exe;

    private WindowsDotArchive() {
    }

    public static final synchronized WindowsDotArchive getInstance() {
        if (singleton == null) {
            singleton = new WindowsDotArchive();
        }
        return singleton;
    }

    public static final String readString(InputStream is) throws IOException {
        int len = WindowsDotArchive.readByte(is);
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append((char)WindowsDotArchive.readByte(is));
        }
        return sb.toString();
    }

    public static final int readNumber(InputStream is) throws IOException {
        int result = WindowsDotArchive.readByte(is);
        result = result * 256 + WindowsDotArchive.readByte(is);
        result = result * 256 + WindowsDotArchive.readByte(is);
        return result;
    }

    private static int readByte(InputStream is) throws IOException {
        return is.read();
    }

    private static void extract(File dir) throws IOException {
        InputStream raw = WindowsDotArchive.class.getResourceAsStream("graphviz.dat");
        try (BrotliInputStream is = new BrotliInputStream(raw);){
            String name;
            block10: while ((name = WindowsDotArchive.readString(is)).length() != 0) {
                int size = WindowsDotArchive.readNumber(is);
                File fileout = new File(dir, name);
                if (fileout.exists()) {
                    int i = 0;
                    while (true) {
                        if (i >= size) continue block10;
                        is.read();
                        ++i;
                    }
                }
                BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(fileout));
                try {
                    int i = 0;
                    while (true) {
                        if (i >= size) continue block10;
                        ((OutputStream)fos).write(is.read());
                        ++i;
                    }
                }
                finally {
                    ((OutputStream)fos).close();
                    continue;
                }
                break;
            }
        }
    }

    public synchronized boolean isThereArchive() {
        if (this.isThereArchive == null) {
            try (InputStream raw = WindowsDotArchive.class.getResourceAsStream("graphviz.dat");){
                this.isThereArchive = raw != null;
            }
            catch (Exception e) {
                this.isThereArchive = false;
            }
        }
        return this.isThereArchive;
    }

    public synchronized File getWindowsExeLite() {
        if (!this.isThereArchive()) {
            return null;
        }
        if (this.exe == null) {
            File tmp = new File(System.getProperty("java.io.tmpdir"), "_graphviz");
            try {
                tmp.mkdirs();
                WindowsDotArchive.extract(tmp);
            }
            catch (IOException e) {
                Logme.error(e);
            }
            this.exe = new File(tmp, "dot.exe");
        }
        return this.exe;
    }
}

