/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.api.cheerpj.v1;

import com.plantuml.api.cheerpj.JsonResult;
import com.plantuml.api.cheerpj.Utils;
import com.plantuml.api.cheerpj.WasmLog;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.g2d.UGraphicG2d;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.preproc.Defines;

public class Raw {
    private static final int MAX = 2000;
    private static BufferedImage im;
    private static Graphics2D g2d;

    public static Object convertToBlob(String mode, String text, String pathOut) {
        long start;
        WasmLog.start = start = System.currentTimeMillis();
        WasmLog.log("Starting processing");
        try {
            ColorMapper mapper;
            HColor back;
            text = Utils.cleanText(text);
            BlockUmlBuilder builder = new BlockUmlBuilder(Collections.emptyList(), StandardCharsets.UTF_8, Defines.createEmpty(), (Reader)new StringReader(text), null, "string");
            List<BlockUml> blocks = builder.getBlockUmls();
            if (blocks.size() == 0) {
                return JsonResult.noDataFound(start);
            }
            WasmLog.log("...loading data...");
            Diagram system = blocks.get(0).getDiagram();
            if (system instanceof PSystemError) {
                ErrorUml error = ((PSystemError)system).getFirstError();
                WasmLog.log("[" + error.getPosition() + "] " + error.getError());
                return JsonResult.fromError(start, (PSystemError)system);
            }
            WasmLog.log("...processing...");
            boolean dark = "dark".equalsIgnoreCase(mode);
            StringBounder stringBounder = FileFormat.PNG.getDefaultStringBounder();
            if (im == null) {
                EmptyImageBuilder imageBuilder = new EmptyImageBuilder(null, 2000, 2000, Color.WHITE, stringBounder);
                im = imageBuilder.getBufferedImage();
                g2d = im.createGraphics();
            }
            if (dark) {
                back = HColors.simple(Color.BLACK);
                mapper = ColorMapper.DARK_MODE;
            } else {
                back = HColors.simple(Color.WHITE);
                mapper = ColorMapper.IDENTITY;
            }
            UGraphicG2d ug = new UGraphicG2d(back, mapper, stringBounder, g2d, 1.0, FileFormat.RAW);
            WasmLog.log("...cleaning...");
            ug.apply(back).apply(back.bg()).draw(URectangle.build(2000.0, 2000.0));
            ug.resetMax();
            WasmLog.log("...drawing...");
            system.exportDiagramGraphic(ug, new FileFormatOption(FileFormat.PNG));
            int width = (int)(2.0 + ug.getMaxX());
            int height = (int)(2.0 + ug.getMaxY());
            WasmLog.log("...size is " + width + " x " + height + " ...");
            FileOutputStream fos = new FileOutputStream(new File(pathOut));
            fos.write((width & 0xFF00) >> 8);
            fos.write(width & 0xFF);
            fos.write((height & 0xFF00) >> 8);
            fos.write(height & 0xFF);
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    int pixel = im.getRGB(i, j);
                    fos.write((pixel & 0xFF0000) >> 16);
                    fos.write((pixel & 0xFF00) >> 8);
                    fos.write(pixel & 0xFF);
                    fos.write(255);
                }
            }
            WasmLog.log("done!");
            ImageDataSimple imageData = new ImageDataSimple(width, height);
            return JsonResult.ok(start, imageData, system);
        }
        catch (Throwable t) {
            WasmLog.log("Fatal error " + t);
            return JsonResult.fromCrash(start, t);
        }
    }

    public static Object convert(String mode, String text) {
        long start;
        WasmLog.start = start = System.currentTimeMillis();
        WasmLog.log("Starting processing");
        try {
            ColorMapper mapper;
            HColor back;
            text = Utils.cleanText(text);
            BlockUmlBuilder builder = new BlockUmlBuilder(Collections.emptyList(), StandardCharsets.UTF_8, Defines.createEmpty(), (Reader)new StringReader(text), null, "string");
            List<BlockUml> blocks = builder.getBlockUmls();
            if (blocks.size() == 0) {
                return JsonResult.noDataFound(start);
            }
            WasmLog.log("...loading data...");
            Diagram system = blocks.get(0).getDiagram();
            if (system instanceof PSystemError) {
                ErrorUml error = ((PSystemError)system).getFirstError();
                WasmLog.log("[" + error.getPosition() + "] " + error.getError());
                return JsonResult.fromError(start, (PSystemError)system);
            }
            WasmLog.log("...processing...");
            boolean dark = "dark".equalsIgnoreCase(mode);
            StringBounder stringBounder = FileFormat.PNG.getDefaultStringBounder();
            if (im == null) {
                EmptyImageBuilder imageBuilder = new EmptyImageBuilder(null, 2000, 2000, Color.WHITE, stringBounder);
                im = imageBuilder.getBufferedImage();
                g2d = im.createGraphics();
            }
            if (dark) {
                back = HColors.simple(Color.BLACK);
                mapper = ColorMapper.DARK_MODE;
            } else {
                back = HColors.simple(Color.WHITE);
                mapper = ColorMapper.IDENTITY;
            }
            UGraphicG2d ug = new UGraphicG2d(back, mapper, stringBounder, g2d, 1.0, FileFormat.RAW);
            WasmLog.log("...cleaning...");
            ug.apply(back).apply(back.bg()).draw(URectangle.build(2000.0, 2000.0));
            ug.resetMax();
            WasmLog.log("...drawing...");
            system.exportDiagramGraphic(ug, new FileFormatOption(FileFormat.PNG));
            int width = (int)(2.0 + ug.getMaxX());
            int height = (int)(2.0 + ug.getMaxY());
            WasmLog.log("...size is " + width + " x " + height + " ...");
            byte[] data = new byte[width * height * 4];
            WasmLog.log("...allocating array...");
            int pos = 0;
            data[pos++] = (byte)((width & 0xFF00) >> 8);
            data[pos++] = (byte)(width & 0xFF);
            data[pos++] = (byte)((height & 0xFF00) >> 8);
            data[pos++] = (byte)(height & 0xFF);
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    int pixel = im.getRGB(i, j);
                    data[pos++] = (byte)((pixel & 0xFF0000) >> 16);
                    data[pos++] = (byte)((pixel & 0xFF00) >> 8);
                    data[pos++] = (byte)(pixel & 0xFF);
                    data[pos++] = -1;
                }
            }
            WasmLog.log("done!");
            return data;
        }
        catch (Throwable t) {
            WasmLog.log("Fatal error " + t);
            return JsonResult.fromCrash(start, t);
        }
    }
}

