/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.opensaml.xmlsec.signature.support.ConfigurableContentReference;
import org.opensaml.xmlsec.signature.support.TransformsConfigurableContentReference;
import org.slf4j.Logger;

public class URIContentReference
implements ConfigurableContentReference,
TransformsConfigurableContentReference {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(URIContentReference.class);
    @Nullable
    private final String referenceID;
    @Nullable
    private String digestAlgorithm;
    @Nonnull
    private final List<String> transforms;

    public URIContentReference(@Nullable String refID) {
        this.referenceID = refID;
        this.transforms = new LinkedList<String>();
        this.digestAlgorithm = "http://www.w3.org/2001/04/xmlenc#sha256";
    }

    @Override
    @Nonnull
    @Live
    public List<String> getTransforms() {
        return this.transforms;
    }

    @Override
    @Nullable
    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    @Override
    public void setDigestAlgorithm(@Nullable String newAlgorithm) {
        this.digestAlgorithm = StringSupport.trimOrNull(newAlgorithm);
    }

    @Override
    public void createReference(@Nonnull XMLSignature signature) {
        try {
            Transforms dsigTransforms = new Transforms(signature.getDocument());
            for (String transform : this.getTransforms()) {
                dsigTransforms.addTransform(transform);
            }
            signature.addDocument(this.referenceID, dsigTransforms, this.digestAlgorithm);
        }
        catch (TransformationException e) {
            this.log.error("Error while creating transforms", (Throwable)e);
        }
        catch (XMLSignatureException e) {
            this.log.error("Error while adding content reference", (Throwable)e);
        }
    }
}

