/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import com.azure.core.util.ConfigurationSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class EnvironmentConfiguration {
    private static final List<String> DEFAULT_CONFIGURATIONS = Arrays.asList("HTTP_PROXY", "HTTPS_PROXY", "IDENTITY_ENDPOINT", "IDENTITY_HEADER", "NO_PROXY", "MSI_ENDPOINT", "MSI_SECRET", "AZURE_SUBSCRIPTION_ID", "AZURE_USERNAME", "AZURE_PASSWORD", "AZURE_CLIENT_ID", "AZURE_CLIENT_SECRET", "AZURE_TENANT_ID", "AZURE_CLIENT_CERTIFICATE_PATH", "AZURE_CLIENT_CERTIFICATE_PASSWORD", "AZURE_IDENTITY_DISABLE_CP1", "AZURE_RESOURCE_GROUP", "AZURE_CLOUD", "AZURE_AUTHORITY_HOST", "AZURE_TELEMETRY_DISABLED", "AZURE_LOG_LEVEL", "AZURE_HTTP_LOG_DETAIL_LEVEL", "AZURE_TRACING_DISABLED", "AZURE_POD_IDENTITY_TOKEN_URL", "AZURE_REGIONAL_AUTHORITY_NAME", "AZURE_REQUEST_RETRY_COUNT", "AZURE_REQUEST_CONNECT_TIMEOUT", "AZURE_REQUEST_WRITE_TIMEOUT", "AZURE_REQUEST_RESPONSE_TIMEOUT", "AZURE_REQUEST_READ_TIMEOUT");
    private static final EnvironmentConfiguration GLOBAL_CONFIGURATION = new EnvironmentConfiguration();
    private final ConcurrentMap<String, String> explicitConfigurations;
    private final ConcurrentMap<String, Optional<String>> envConfigurations;
    private final ConcurrentMap<String, Optional<String>> sysPropertiesConfigurations;

    private EnvironmentConfiguration() {
        this(EnvironmentVariablesConfigurationSource.GLOBAL_SOURCE, path -> Collections.emptyMap());
    }

    public EnvironmentConfiguration(EnvironmentConfiguration original) {
        this.explicitConfigurations = new ConcurrentHashMap<String, String>(original.explicitConfigurations);
        this.envConfigurations = new ConcurrentHashMap<String, Optional<String>>(original.envConfigurations);
        this.sysPropertiesConfigurations = new ConcurrentHashMap<String, Optional<String>>(original.sysPropertiesConfigurations);
    }

    public EnvironmentConfiguration(ConfigurationSource systemPropertiesConfigurationSource, ConfigurationSource environmentConfigurationSource) {
        this.explicitConfigurations = new ConcurrentHashMap<String, String>();
        if (environmentConfigurationSource == null) {
            environmentConfigurationSource = EnvironmentVariablesConfigurationSource.GLOBAL_SOURCE;
        }
        Map<String, String> fromEnvironment = environmentConfigurationSource.getProperties(null);
        Objects.requireNonNull(fromEnvironment, "'environmentConfigurationSource.getProperties(null)' can't be null");
        this.envConfigurations = new ConcurrentHashMap<String, Optional<String>>(fromEnvironment.size());
        for (Map.Entry<String, String> config : fromEnvironment.entrySet()) {
            this.envConfigurations.put(config.getKey(), Optional.ofNullable(config.getValue()));
        }
        if (systemPropertiesConfigurationSource == null) {
            this.sysPropertiesConfigurations = new ConcurrentHashMap<String, Optional<String>>();
        } else {
            Map<String, String> fromSystemProperties = systemPropertiesConfigurationSource.getProperties(null);
            Objects.requireNonNull(fromSystemProperties, "'systemPropertiesConfigurationSource.getProperties(null)' can't be null");
            this.sysPropertiesConfigurations = new ConcurrentHashMap<String, Optional<String>>(fromSystemProperties.size());
            for (Map.Entry<String, String> config : fromSystemProperties.entrySet()) {
                this.sysPropertiesConfigurations.put(config.getKey(), Optional.ofNullable(config.getValue()));
            }
        }
    }

    public static EnvironmentConfiguration getGlobalConfiguration() {
        return GLOBAL_CONFIGURATION;
    }

    public String getEnvironmentVariable(String name) {
        return this.getOrLoad(name, this.envConfigurations, false);
    }

    public String getSystemProperty(String name) {
        return this.getOrLoad(name, this.sysPropertiesConfigurations, true);
    }

    public String get(String name) {
        String value = (String)this.explicitConfigurations.get(name);
        if (value != null) {
            return value;
        }
        value = this.getSystemProperty(name);
        if (value != null) {
            return value;
        }
        return this.getEnvironmentVariable(name);
    }

    private String getOrLoad(String name, ConcurrentMap<String, Optional<String>> configurations, boolean loadFromSystemProperties) {
        Optional value = (Optional)configurations.get(name);
        if (value != null) {
            return value.orElse(null);
        }
        String envValue = loadFromSystemProperties ? this.loadFromProperties(name) : this.loadFromEnvironment(name);
        configurations.put(name, Optional.ofNullable(envValue));
        return envValue;
    }

    public EnvironmentConfiguration put(String name, String value) {
        this.explicitConfigurations.put(name, value);
        return this;
    }

    public String remove(String name) {
        return (String)this.explicitConfigurations.remove(name);
    }

    private String loadFromEnvironment(String name) {
        return System.getenv(name);
    }

    private String loadFromProperties(String name) {
        return System.getProperty(name);
    }

    public static final class EnvironmentVariablesConfigurationSource
    implements ConfigurationSource {
        public static final ConfigurationSource GLOBAL_SOURCE = new EnvironmentVariablesConfigurationSource();
        private final Map<String, String> configurations = new HashMap<String, String>();

        private EnvironmentVariablesConfigurationSource() {
            for (String config : DEFAULT_CONFIGURATIONS) {
                String value = System.getenv(config);
                if (value == null) continue;
                this.configurations.put(config, value);
            }
        }

        @Override
        public Map<String, String> getProperties(String ignored) {
            return this.configurations;
        }
    }
}

