/*
 * Decompiled with CFR 0.152.
 */
package com.azure.xml.implementation.aalto.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public final class UriCanonicalizer {
    private BoundedHashMap mURIs = null;
    private final ReentrantLock lock = new ReentrantLock();

    private void init() {
        this.mURIs = new BoundedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String canonicalizeURI(char[] ch, int len) {
        this.lock.lock();
        try {
            CanonicalKey key = new CanonicalKey(ch, len);
            if (this.mURIs == null) {
                this.init();
            } else {
                String result = (String)this.mURIs.get(key);
                if (result != null) {
                    String string = result;
                    return string;
                }
            }
            key = key.safeClone();
            String uri = new String(ch, 0, len).intern();
            this.mURIs.put(key, uri);
            String string = uri;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    static final class BoundedHashMap
    extends LinkedHashMap<CanonicalKey, String> {
        private static final int DEFAULT_SIZE = 64;
        private static final int MAX_SIZE = 716;

        public BoundedHashMap() {
            super(64, 0.7f, true);
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<CanonicalKey, String> entry) {
            return this.size() >= 716;
        }
    }

    static final class CanonicalKey {
        final char[] mChars;
        final int mLength;
        final int mHash;

        public CanonicalKey(char[] buffer, int len) {
            this.mChars = buffer;
            this.mLength = len;
            this.mHash = CanonicalKey.calcKeyHash(buffer, len);
        }

        public CanonicalKey(char[] buffer, int len, int hashCode) {
            this.mChars = buffer;
            this.mLength = len;
            this.mHash = hashCode;
        }

        public CanonicalKey safeClone() {
            char[] newBuf = new char[this.mLength];
            System.arraycopy(this.mChars, 0, newBuf, 0, this.mLength);
            return new CanonicalKey(newBuf, this.mLength, this.mHash);
        }

        public static int calcKeyHash(char[] buffer, int len) {
            if (len <= 8) {
                int hash = buffer[0];
                for (int i = 1; i < len; ++i) {
                    hash = hash * 31 + buffer[i];
                }
                return hash;
            }
            int hash = len ^ buffer[0];
            int ix = 2;
            int dist = 2;
            int end = len - 4;
            while (ix < end) {
                hash = hash * 31 + buffer[ix];
                ix += dist;
                ++dist;
            }
            hash = hash * 31 ^ (buffer[end] << 2) + buffer[end + 1];
            hash = hash * 31 + (buffer[end + 2] << 2) ^ buffer[end + 3];
            return hash;
        }

        public String toString() {
            return "{URI, hash: 0x" + Integer.toHexString(this.mHash) + "}";
        }

        public int hashCode() {
            return this.mHash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            CanonicalKey other = (CanonicalKey)o;
            if (other.mLength != this.mLength) {
                return false;
            }
            for (int i = 0; i < this.mLength; ++i) {
                if (this.mChars[i] == other.mChars[i]) continue;
                return false;
            }
            return true;
        }
    }
}

