/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import reactor.core.publisher.Mono;

public class StorageBearerTokenChallengeAuthorizationPolicy
extends BearerTokenAuthenticationPolicy {
    private static final ClientLogger LOGGER = new ClientLogger(StorageBearerTokenChallengeAuthorizationPolicy.class);
    private static final String DEFAULT_SCOPE = "/.default";
    static final String BEARER_TOKEN_PREFIX = "Bearer ";
    private String[] scopes;

    public StorageBearerTokenChallengeAuthorizationPolicy(TokenCredential credential, String ... scopes) {
        super(credential, scopes);
        this.scopes = scopes;
    }

    public Mono<Void> authorizeRequest(HttpPipelineCallContext context) {
        String[] scopes = this.scopes;
        if ((scopes = this.getScopes(context, scopes)) == null) {
            return Mono.empty();
        }
        return this.setAuthorizationHeader(context, new TokenRequestContext().addScopes(scopes));
    }

    public void authorizeRequestSync(HttpPipelineCallContext context) {
        String[] scopes = this.scopes;
        if ((scopes = this.getScopes(context, scopes)) != null) {
            this.setAuthorizationHeaderSync(context, new TokenRequestContext().addScopes(scopes));
        }
    }

    public Mono<Boolean> authorizeRequestOnChallenge(HttpPipelineCallContext context, HttpResponse response) {
        String authHeader = response.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        Map<String, String> challenges = this.extractChallengeAttributes(authHeader, BEARER_TOKEN_PREFIX);
        String scope = this.getScopeFromChallenges(challenges);
        String authorization = this.getAuthorizationFromChallenges(challenges);
        if (scope != null) {
            scope = scope + DEFAULT_SCOPE;
            this.scopes = new String[]{scope};
            this.scopes = this.getScopes(context, this.scopes);
        }
        if (authorization != null) {
            String tenantId = this.extractTenantIdFromUri(authorization);
            TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(this.scopes).setTenantId(tenantId);
            return this.setAuthorizationHeader(context, tokenRequestContext).thenReturn((Object)true);
        }
        if (scope != null) {
            TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(this.scopes);
            return this.setAuthorizationHeader(context, tokenRequestContext).thenReturn((Object)true);
        }
        return Mono.just((Object)false);
    }

    String extractTenantIdFromUri(String uri) {
        try {
            String[] segments = new URI(uri).getPath().split("/");
            if (segments.length > 1) {
                return segments[1];
            }
            throw LOGGER.logExceptionAsError(new RuntimeException("Invalid authorization URI: tenantId not found"));
        }
        catch (URISyntaxException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Invalid authorization URI", e));
        }
    }

    public boolean authorizeRequestOnChallengeSync(HttpPipelineCallContext context, HttpResponse response) {
        String authHeader = response.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        Map<String, String> challenges = this.extractChallengeAttributes(authHeader, BEARER_TOKEN_PREFIX);
        String scope = this.getScopeFromChallenges(challenges);
        String authorization = this.getAuthorizationFromChallenges(challenges);
        if (scope != null) {
            scope = scope + DEFAULT_SCOPE;
            this.scopes = new String[]{scope};
            this.scopes = this.getScopes(context, this.scopes);
        }
        if (authorization != null) {
            String tenantId = this.extractTenantIdFromUri(authorization);
            TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(this.scopes).setTenantId(tenantId);
            this.setAuthorizationHeaderSync(context, tokenRequestContext);
            return true;
        }
        if (scope != null) {
            TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(this.scopes);
            this.setAuthorizationHeaderSync(context, tokenRequestContext);
            return true;
        }
        return false;
    }

    String[] getScopes(HttpPipelineCallContext context, String[] scopes) {
        return (String[])CoreUtils.clone((Object[])scopes);
    }

    Map<String, String> extractChallengeAttributes(String header, String authChallengePrefix) {
        if (!StorageBearerTokenChallengeAuthorizationPolicy.isBearerChallenge(header, authChallengePrefix)) {
            return Collections.emptyMap();
        }
        header = header.toLowerCase(Locale.ROOT).replace(authChallengePrefix.toLowerCase(Locale.ROOT), "");
        String[] attributes = header.split(" ");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (String pair : attributes) {
            String[] keyValue = pair.split("=");
            attributeMap.put(keyValue[0].replaceAll("\"", ""), keyValue[1].replaceAll("\"", ""));
        }
        return attributeMap;
    }

    static boolean isBearerChallenge(String authenticateHeader, String authChallengePrefix) {
        return !CoreUtils.isNullOrEmpty((CharSequence)authenticateHeader) && authenticateHeader.toLowerCase(Locale.ROOT).startsWith(authChallengePrefix.toLowerCase(Locale.ROOT));
    }

    String getScopeFromChallenges(Map<String, String> challenges) {
        return challenges.get("resource_id");
    }

    String getAuthorizationFromChallenges(Map<String, String> challenges) {
        return challenges.get("authorization_uri");
    }
}

