/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.NumberPropertyBase;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ScaledFloatNumberProperty
extends NumberPropertyBase
implements PropertyVariant,
ToCopyableBuilder<Builder, ScaledFloatNumberProperty> {
    @Nullable
    private final Double nullValue;
    @Nullable
    private final Double scalingFactor;
    public static final JsonpDeserializer<ScaledFloatNumberProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScaledFloatNumberProperty::setupScaledFloatNumberPropertyDeserializer);

    private ScaledFloatNumberProperty(Builder builder) {
        super(builder);
        this.nullValue = builder.nullValue;
        this.scalingFactor = builder.scalingFactor;
    }

    public static ScaledFloatNumberProperty of(Function<Builder, ObjectBuilder<ScaledFloatNumberProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.ScaledFloat;
    }

    @Nullable
    public final Double nullValue() {
        return this.nullValue;
    }

    @Nullable
    public final Double scalingFactor() {
        return this.scalingFactor;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "scaled_float");
        super.serializeInternal(generator, mapper);
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue.doubleValue());
        }
        if (this.scalingFactor != null) {
            generator.writeKey("scaling_factor");
            generator.write(this.scalingFactor.doubleValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupScaledFloatNumberPropertyDeserializer(ObjectDeserializer<Builder> op) {
        ScaledFloatNumberProperty.setupNumberPropertyBaseDeserializer(op);
        op.add(Builder::nullValue, JsonpDeserializer.doubleDeserializer(), "null_value");
        op.add(Builder::scalingFactor, JsonpDeserializer.doubleDeserializer(), "scaling_factor");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.nullValue);
        result = 31 * result + Objects.hashCode(this.scalingFactor);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScaledFloatNumberProperty other = (ScaledFloatNumberProperty)o;
        return Objects.equals(this.nullValue, other.nullValue) && Objects.equals(this.scalingFactor, other.scalingFactor);
    }

    public static class Builder
    extends NumberPropertyBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ScaledFloatNumberProperty> {
        @Nullable
        private Double nullValue;
        @Nullable
        private Double scalingFactor;

        public Builder() {
        }

        private Builder(ScaledFloatNumberProperty o) {
            super(o);
            this.nullValue = o.nullValue;
            this.scalingFactor = o.scalingFactor;
        }

        private Builder(Builder o) {
            super(o);
            this.nullValue = o.nullValue;
            this.scalingFactor = o.scalingFactor;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder nullValue(@Nullable Double value) {
            this.nullValue = value;
            return this;
        }

        @Nonnull
        public final Builder scalingFactor(@Nullable Double value) {
            this.scalingFactor = value;
            return this;
        }

        @Override
        @Nonnull
        public ScaledFloatNumberProperty build() {
            this._checkSingleUse();
            return new ScaledFloatNumberProperty(this);
        }
    }
}

