/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.collector;

import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.opensearch.neuralsearch.query.HybridSubQueryScorer;

public abstract class HybridLeafCollector
implements LeafCollector {
    @Generated
    private static final Logger log = LogManager.getLogger(HybridLeafCollector.class);
    HybridSubQueryScorer compoundQueryScorer;

    public void setScorer(Scorable scorer) throws IOException {
        if (scorer instanceof HybridSubQueryScorer) {
            this.compoundQueryScorer = (HybridSubQueryScorer)scorer;
        } else {
            this.compoundQueryScorer = this.getHybridQueryScorer(scorer);
            if (Objects.isNull((Object)this.compoundQueryScorer)) {
                log.error("cannot find scorer of type HybridQueryScorer in a hierarchy of scorer {}", (Object)scorer);
            }
        }
    }

    private HybridSubQueryScorer getHybridQueryScorer(Scorable scorer) throws IOException {
        if (Objects.isNull(scorer)) {
            return null;
        }
        if (scorer instanceof HybridSubQueryScorer) {
            return (HybridSubQueryScorer)scorer;
        }
        for (Scorable.ChildScorable childScorable : scorer.getChildren()) {
            HybridSubQueryScorer hybridQueryScorer = this.getHybridQueryScorer(childScorable.child());
            if (!Objects.nonNull((Object)hybridQueryScorer)) continue;
            log.debug("found hybrid query scorer, it's child of scorer {}", (Object)childScorable.child().getClass().getSimpleName());
            return hybridQueryScorer;
        }
        return null;
    }

    @Generated
    HybridSubQueryScorer getCompoundQueryScorer() {
        return this.compoundQueryScorer;
    }
}

