/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.codec;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.neuralsearch.sparse.codec.CodecUtilWrapper;
import org.opensearch.neuralsearch.sparse.data.DocWeight;
import org.opensearch.neuralsearch.sparse.data.DocumentCluster;
import org.opensearch.neuralsearch.sparse.data.PostingClusters;
import org.opensearch.neuralsearch.sparse.data.SparseVector;

public class SparseTermsLuceneReader
extends FieldsProducer {
    @Generated
    private static final Logger log = LogManager.getLogger(SparseTermsLuceneReader.class);
    private final Map<String, Map<BytesRef, Long>> fieldToTerms = new HashMap<String, Map<BytesRef, Long>>();
    private IndexInput termsIn;
    private IndexInput postingIn;
    private final CodecUtilWrapper codecUtilWrapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SparseTermsLuceneReader(SegmentReadState state, CodecUtilWrapper codecUtilWrapper) {
        this.codecUtilWrapper = codecUtilWrapper;
        String termsFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"sit");
        String postingFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"sip");
        boolean success = false;
        try {
            this.termsIn = state.directory.openInput(termsFileName, state.context);
            this.codecUtilWrapper.checkIndexHeader((DataInput)this.termsIn, "SparsePostingsProducer", 1, 1, state.segmentInfo.getId(), state.segmentSuffix);
            this.codecUtilWrapper.retrieveChecksum(this.termsIn);
            this.seekDir(this.termsIn);
            this.postingIn = state.directory.openInput(postingFileName, state.context);
            this.codecUtilWrapper.checkIndexHeader((DataInput)this.postingIn, "SparsePostingsProducer", 1, 1, state.segmentInfo.getId(), state.segmentSuffix);
            this.codecUtilWrapper.retrieveChecksum(this.postingIn);
            int numberOfFields = this.termsIn.readVInt();
            for (int i = 0; i < numberOfFields; ++i) {
                int fieldId = this.termsIn.readVInt();
                int numberOfTerms = (int)this.termsIn.readVLong();
                HashMap<BytesRef, Long> terms = new HashMap<BytesRef, Long>(numberOfTerms);
                for (int j = 0; j < numberOfTerms; ++j) {
                    int byteLength = this.termsIn.readVInt();
                    BytesRef term = new BytesRef(byteLength);
                    term.length = byteLength;
                    this.termsIn.readBytes(term.bytes, term.offset, byteLength);
                    long fileOffset = this.termsIn.readVLong();
                    terms.put(term, fileOffset);
                }
                this.fieldToTerms.put(state.fieldInfos.fieldInfo(fieldId).getName(), terms);
            }
            success = true;
            if (success) return;
        }
        catch (Exception e) {
            try {
                log.error("Read sparse terms error", (Throwable)e);
                if (success) return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.termsIn, this.postingIn});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.termsIn, this.postingIn});
            return;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.termsIn, this.postingIn});
        return;
    }

    private void seekDir(IndexInput input) throws IOException {
        input.seek(input.length() - (long)this.codecUtilWrapper.footerLength() - 8L);
        long dirOffset = input.readLong();
        input.seek(dirOffset);
    }

    public Iterator<String> iterator() {
        return this.fieldToTerms.keySet().iterator();
    }

    public Terms terms(String field) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Set<BytesRef> getTerms(String field) {
        Map<BytesRef, Long> termsMapping = this.fieldToTerms.get(field);
        if (termsMapping == null) {
            return Set.of();
        }
        return termsMapping.keySet();
    }

    public PostingClusters read(String field, BytesRef term) throws IOException {
        Map<BytesRef, Long> termsMapping = this.fieldToTerms.get(field);
        if (termsMapping == null) {
            return null;
        }
        if (!termsMapping.containsKey(term)) {
            return null;
        }
        long offset = termsMapping.get(term);
        List<DocumentCluster> clusters = this.readClusters(offset);
        if (clusters.isEmpty()) {
            return null;
        }
        return new PostingClusters(clusters);
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.termsIn, this.postingIn});
    }

    public void checkIntegrity() throws IOException {
        this.codecUtilWrapper.checksumEntireFile(this.termsIn);
        this.codecUtilWrapper.checksumEntireFile(this.postingIn);
    }

    private synchronized List<DocumentCluster> readClusters(long offset) throws IOException {
        this.postingIn.seek(offset);
        long clusterSize = this.postingIn.readVLong();
        ArrayList<DocumentCluster> clusters = new ArrayList<DocumentCluster>((int)clusterSize);
        int j = 0;
        while ((long)j < clusterSize) {
            long docSize = this.postingIn.readVLong();
            ArrayList<DocWeight> docs = new ArrayList<DocWeight>((int)docSize);
            int k = 0;
            while ((long)k < docSize) {
                docs.add(new DocWeight(this.postingIn.readVInt(), this.postingIn.readByte()));
                ++k;
            }
            boolean shouldNotSkip = this.postingIn.readByte() == 1;
            long summaryVectorSize = this.postingIn.readVLong();
            ArrayList<SparseVector.Item> items = new ArrayList<SparseVector.Item>((int)summaryVectorSize);
            int k2 = 0;
            while ((long)k2 < summaryVectorSize) {
                items.add(new SparseVector.Item(this.postingIn.readVInt(), this.postingIn.readByte()));
                ++k2;
            }
            SparseVector summary = items.isEmpty() ? null : new SparseVector(items);
            DocumentCluster cluster = new DocumentCluster(summary, docs, shouldNotSkip);
            clusters.add(cluster);
            ++j;
        }
        return clusters;
    }
}

