/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.stats.suppliers;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;

public class EventOccurredWithinThresholdSupplier
implements Supplier<Boolean> {
    private final long threshold;
    private final ChronoUnit unit;
    private final Supplier<Instant> supplier;

    public EventOccurredWithinThresholdSupplier(Supplier<Instant> supplier, long threshold, ChronoUnit unit) {
        this.supplier = supplier;
        this.threshold = threshold;
        this.unit = unit;
    }

    @Override
    public Boolean get() {
        Instant lastSeenAt = this.supplier.get();
        if (lastSeenAt == null) {
            return false;
        }
        Instant expiringAt = lastSeenAt.plus(this.threshold, this.unit);
        if (expiringAt.compareTo(Instant.now()) > 0) {
            return true;
        }
        return false;
    }
}

