/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.fips.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.Signer;
import org.bouncycastle.crypto.internal.Xof;
import org.bouncycastle.math.ec.rfc8032.Ed448;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class HashEd448Signer
implements Signer {
    private final Ed448 ed448 = new Ed448(){

        @Override
        protected Xof createXof() {
            return (Xof)FipsSHS.createDigest(FipsSHS.Algorithm.SHAKE256);
        }
    };
    private final Xof prehash = this.ed448.createPrehash();
    private final byte[] context;
    private boolean forSigning;
    private Ed448PrivateKeyParameters privateKey;
    private Ed448PublicKeyParameters publicKey;

    public HashEd448Signer(byte[] byArray) {
        if (null == byArray) {
            throw new NullPointerException("'context' cannot be null");
        }
        this.context = Arrays.clone(byArray);
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        if (bl) {
            this.privateKey = (Ed448PrivateKeyParameters)cipherParameters;
            this.publicKey = null;
        } else {
            this.privateKey = null;
            this.publicKey = (Ed448PublicKeyParameters)cipherParameters;
        }
        this.reset();
    }

    @Override
    public void update(byte by) {
        this.prehash.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.prehash.update(byArray, n, n2);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.forSigning || null == this.privateKey) {
            throw new IllegalStateException("Ed448phSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[64];
        if (64 != this.prehash.doFinal(byArray, 0, 64)) {
            throw new IllegalStateException("Prehash digest failed");
        }
        byte[] byArray2 = new byte[114];
        this.privateKey.sign(1, this.context, byArray, 0, 64, byArray2, 0);
        return byArray2;
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        if (this.forSigning || null == this.publicKey) {
            throw new IllegalStateException("Ed448phSigner not initialised for verification");
        }
        if (114 != byArray.length) {
            this.prehash.reset();
            return false;
        }
        byte[] byArray2 = new byte[64];
        if (64 != this.prehash.doFinal(byArray2, 0, 64)) {
            throw new IllegalStateException("Prehash digest failed");
        }
        return this.publicKey.verify(1, this.context, byArray2, 0, 64, byArray, 0);
    }

    @Override
    public void reset() {
        this.prehash.reset();
    }
}

