/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirExpressionSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J=\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016R\u00020\u0010R\u00020\u0012j\u0006\u0010\u0011\u001a\u00020\u0010j\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0016J5\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0018H\u0016R\u00020\u0010R\u00020\u0012j\u0006\u0010\u0011\u001a\u00020\u0010j\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0019R\u0018\u0010\u000b\u001a\u00020\u0007*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u001a\u001a\u00020\u0007*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0018\u0010\u001d\u001a\u00020\u0007*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirAnnotatedBinaryExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExpressionSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lcom/intellij/psi/PsiElement;", "<init>", "()V", "isApplicable", "", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "hasAnnotatedLhs", "getHasAnnotatedLhs", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "checkPsi", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "psi", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;Lorg/jetbrains/kotlin/KtPsiSourceElement;Lcom/intellij/psi/PsiElement;)V", "checkLightTree", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;Lorg/jetbrains/kotlin/KtLightSourceElement;)V", "isStatementContainer", "Lcom/intellij/lang/LighterASTNode;", "(Lcom/intellij/lang/LighterASTNode;)Z", "isContainerNodeForControlStructureBody", "checkers"})
public final class FirAnnotatedBinaryExpressionChecker
extends FirExpressionSyntaxChecker<FirStatement, PsiElement> {
    @NotNull
    public static final FirAnnotatedBinaryExpressionChecker INSTANCE = new FirAnnotatedBinaryExpressionChecker();

    private FirAnnotatedBinaryExpressionChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirStatement element, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        return source.getKind() instanceof KtRealSourceElementKind && Intrinsics.areEqual(source.getElementType(), KtNodeTypes.BINARY_EXPRESSION) && this.getHasAnnotatedLhs(source);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getHasAnnotatedLhs(KtSourceElement $this$hasAnnotatedLhs) {
        PsiElement psiElement = KtSourceElementKt.getPsi($this$hasAnnotatedLhs);
        KtBinaryExpression ktBinaryExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
        if ((ktBinaryExpression != null ? ktBinaryExpression.getLeft() : null) instanceof KtAnnotatedExpression) return true;
        LighterASTNode lighterASTNode = ArraysKt.firstOrNull(LightTreePositioningStrategiesKt.getChildrenArray($this$hasAnnotatedLhs.getTreeStructure(), $this$hasAnnotatedLhs.getLighterASTNode()));
        if (!Intrinsics.areEqual(lighterASTNode != null ? lighterASTNode.getTokenType() : null, KtNodeTypes.ANNOTATED_EXPRESSION)) return false;
        return true;
    }

    @Override
    public void checkPsi(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirStatement element, @NotNull KtPsiSourceElement source, @NotNull PsiElement psi) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(psi, "psi");
        PsiElement current = source.getPsi();
        PsiElement parent2 = current.getParent();
        while (parent2 instanceof KtBinaryExpression) {
            if (!Intrinsics.areEqual(((KtBinaryExpression)parent2).getLeft(), current)) {
                return;
            }
            current = parent2;
            parent2 = ((KtBinaryExpression)parent2).getParent();
        }
        if (KtPsiUtil.isStatementContainer(parent2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getANNOTATIONS_ON_BLOCK_LEVEL_EXPRESSION_ON_THE_SAME_LINE(), null, 8, null);
        }
    }

    @Override
    public void checkLightTree(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirStatement element, @NotNull KtLightSourceElement source) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        LighterASTNode current = source.getLighterASTNode();
        LighterASTNode parent2 = source.getTreeStructure().getParent(current);
        while (true) {
            LighterASTNode lighterASTNode = parent2;
            if (!Intrinsics.areEqual(lighterASTNode != null ? lighterASTNode.getTokenType() : null, KtNodeTypes.BINARY_EXPRESSION)) break;
            if (!Intrinsics.areEqual(ArraysKt.firstOrNull(LightTreePositioningStrategiesKt.getChildrenArray(source.getTreeStructure(), parent2)), current)) {
                return;
            }
            current = parent2;
            parent2 = source.getTreeStructure().getParent(parent2);
        }
        LighterASTNode lighterASTNode = parent2;
        boolean bl = lighterASTNode != null ? this.isStatementContainer(lighterASTNode) : false;
        if (bl) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getANNOTATIONS_ON_BLOCK_LEVEL_EXPRESSION_ON_THE_SAME_LINE(), null, 8, null);
        }
    }

    private final boolean isStatementContainer(LighterASTNode $this$isStatementContainer) {
        return Intrinsics.areEqual($this$isStatementContainer.getTokenType(), KtNodeTypes.BLOCK) || Intrinsics.areEqual($this$isStatementContainer.getTokenType(), KtNodeTypes.WHEN_ENTRY) || this.isContainerNodeForControlStructureBody($this$isStatementContainer);
    }

    private final boolean isContainerNodeForControlStructureBody(LighterASTNode $this$isContainerNodeForControlStructureBody) {
        return Intrinsics.areEqual($this$isContainerNodeForControlStructureBody.getTokenType(), KtNodeTypes.BODY) || Intrinsics.areEqual($this$isContainerNodeForControlStructureBody.getTokenType(), KtNodeTypes.ELSE) || Intrinsics.areEqual($this$isContainerNodeForControlStructureBody.getTokenType(), KtNodeTypes.THEN);
    }
}

