/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.keycloak.common.Profile;
import org.keycloak.models.IdentityProviderShowInAccountConsole;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.models.RealmModel;

public class IdentityProviderModel
implements Serializable {
    public static final String ALIAS = "alias";
    public static final String ALIAS_NOT_IN = "aliasNotIn";
    public static final String ISSUER = "issuer";
    public static final String ALLOWED_CLOCK_SKEW = "allowedClockSkew";
    public static final String AUTHENTICATE_BY_DEFAULT = "authenticateByDefault";
    public static final String CASE_SENSITIVE_ORIGINAL_USERNAME = "caseSensitiveOriginalUsername";
    public static final String CLAIM_FILTER_NAME = "claimFilterName";
    public static final String CLAIM_FILTER_VALUE = "claimFilterValue";
    public static final String DISPLAY_NAME = "displayName";
    public static final String DO_NOT_STORE_USERS = "doNotStoreUsers";
    public static final String ENABLED = "enabled";
    public static final String FILTERED_BY_CLAIMS = "filteredByClaim";
    public static final String FIRST_BROKER_LOGIN_FLOW_ID = "firstBrokerLoginFlowId";
    public static final String HIDE_ON_LOGIN = "hideOnLogin";
    @Deprecated
    public static final String LEGACY_HIDE_ON_LOGIN_ATTR = "hideOnLoginPage";
    public static final String LINK_ONLY = "linkOnly";
    public static final String LOGIN_HINT = "loginHint";
    public static final String METADATA_DESCRIPTOR_URL = "metadataDescriptorUrl";
    public static final String ORGANIZATION_ID = "organizationId";
    public static final String ORGANIZATION_ID_NOT_NULL = "organizationIdNotNull";
    public static final String PASS_MAX_AGE = "passMaxAge";
    public static final String POST_BROKER_LOGIN_FLOW_ID = "postBrokerLoginFlowId";
    public static final String SEARCH = "search";
    public static final String SYNC_MODE = "syncMode";
    public static final String MIN_VALIDITY_TOKEN = "minValidityToken";
    public static final String SHOW_IN_ACCOUNT_CONSOLE = "showInAccountConsole";
    public static final int DEFAULT_MIN_VALIDITY_TOKEN = 5;
    private String internalId;
    private String alias;
    private String providerId;
    private boolean enabled;
    private Boolean trustEmail;
    private Boolean storeToken;
    protected Boolean addReadTokenRoleOnCreate;
    protected Boolean linkOnly;
    private Boolean authenticateByDefault;
    private String firstBrokerLoginFlowId;
    private String postBrokerLoginFlowId;
    private String organizationId;
    private String displayName;
    private String displayIconClasses;
    private Boolean hideOnLogin;
    private Map<String, String> config = new HashMap<String, String>();

    public IdentityProviderModel() {
    }

    public IdentityProviderModel(IdentityProviderModel model) {
        if (model != null) {
            this.internalId = model.getInternalId();
            this.providerId = model.getProviderId();
            this.alias = model.getAlias();
            this.displayName = model.getDisplayName();
            this.config = new HashMap<String, String>(model.getConfig());
            this.enabled = model.isEnabled();
            this.trustEmail = model.isTrustEmail();
            this.storeToken = model.isStoreToken();
            this.linkOnly = model.isLinkOnly();
            this.authenticateByDefault = model.isAuthenticateByDefault();
            this.addReadTokenRoleOnCreate = model.addReadTokenRoleOnCreate;
            this.firstBrokerLoginFlowId = model.getFirstBrokerLoginFlowId();
            this.postBrokerLoginFlowId = model.getPostBrokerLoginFlowId();
            this.organizationId = model.getOrganizationId();
            this.displayIconClasses = model.getDisplayIconClasses();
            this.hideOnLogin = model.isHideOnLogin();
        }
    }

    public String getInternalId() {
        return this.internalId;
    }

    public void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String id) {
        this.alias = id;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean isStoreToken() {
        return this.storeToken;
    }

    public void setStoreToken(Boolean storeToken) {
        this.storeToken = storeToken;
    }

    public Boolean isLinkOnly() {
        return this.linkOnly;
    }

    public void setLinkOnly(Boolean linkOnly) {
        this.linkOnly = linkOnly;
    }

    @Deprecated
    public Boolean isAuthenticateByDefault() {
        return this.authenticateByDefault;
    }

    @Deprecated
    public void setAuthenticateByDefault(Boolean authenticateByDefault) {
        this.authenticateByDefault = authenticateByDefault;
    }

    public String getFirstBrokerLoginFlowId() {
        return this.firstBrokerLoginFlowId;
    }

    public void setFirstBrokerLoginFlowId(String firstBrokerLoginFlowId) {
        this.firstBrokerLoginFlowId = firstBrokerLoginFlowId;
    }

    public String getPostBrokerLoginFlowId() {
        return this.postBrokerLoginFlowId;
    }

    public void setPostBrokerLoginFlowId(String postBrokerLoginFlowId) {
        this.postBrokerLoginFlowId = postBrokerLoginFlowId;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public Boolean isAddReadTokenRoleOnCreate() {
        return this.addReadTokenRoleOnCreate;
    }

    public void setAddReadTokenRoleOnCreate(Boolean addReadTokenRoleOnCreate) {
        this.addReadTokenRoleOnCreate = addReadTokenRoleOnCreate;
    }

    public Boolean isTrustEmail() {
        return this.trustEmail;
    }

    public void setTrustEmail(Boolean trustEmail) {
        this.trustEmail = trustEmail;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayIconClasses() {
        return this.displayIconClasses;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void validate(RealmModel realm) {
    }

    public IdentityProviderSyncMode getSyncMode() {
        String syncMode = this.getConfig().get(SYNC_MODE);
        return syncMode != null ? IdentityProviderSyncMode.valueOf(syncMode) : null;
    }

    public void setSyncMode(IdentityProviderSyncMode syncMode) {
        this.getConfig().put(SYNC_MODE, syncMode != null ? syncMode.toString() : null);
    }

    public boolean isLoginHint() {
        return this.getBooleanConfig(LOGIN_HINT);
    }

    public void setLoginHint(Boolean loginHint) {
        this.setBooleanConfig(LOGIN_HINT, loginHint);
    }

    public boolean isPassMaxAge() {
        return this.getBooleanConfig(PASS_MAX_AGE);
    }

    public void setPassMaxAge(Boolean passMaxAge) {
        this.setBooleanConfig(PASS_MAX_AGE, passMaxAge);
    }

    public Boolean isHideOnLogin() {
        return this.hideOnLogin;
    }

    public void setHideOnLogin(Boolean hideOnLogin) {
        this.hideOnLogin = hideOnLogin;
    }

    public boolean isTransientUsers() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.TRANSIENT_USERS) && this.getBooleanConfig(DO_NOT_STORE_USERS);
    }

    public void setTransientUsers(Boolean transientUsers) {
        this.setBooleanConfig(DO_NOT_STORE_USERS, transientUsers);
    }

    public boolean isFilteredByClaims() {
        return this.getBooleanConfig(FILTERED_BY_CLAIMS);
    }

    public void setFilteredByClaims(Boolean filteredByClaims) {
        this.setBooleanConfig(FILTERED_BY_CLAIMS, filteredByClaims);
    }

    public String getClaimFilterName() {
        return String.valueOf(this.getConfig().getOrDefault(CLAIM_FILTER_NAME, ""));
    }

    public void setClaimFilterName(String claimFilterName) {
        this.getConfig().put(CLAIM_FILTER_NAME, claimFilterName);
    }

    public String getClaimFilterValue() {
        return String.valueOf(this.getConfig().getOrDefault(CLAIM_FILTER_VALUE, ""));
    }

    public void setClaimFilterValue(String claimFilterValue) {
        this.getConfig().put(CLAIM_FILTER_VALUE, claimFilterValue);
    }

    public String getMetadataDescriptorUrl() {
        return this.getConfig().get(METADATA_DESCRIPTOR_URL);
    }

    public void setMetadataDescriptorUrl(String metadataDescriptorUrl) {
        this.getConfig().put(METADATA_DESCRIPTOR_URL, metadataDescriptorUrl);
    }

    public boolean isCaseSensitiveOriginalUsername() {
        return this.getBooleanConfig(CASE_SENSITIVE_ORIGINAL_USERNAME);
    }

    public void setCaseSensitiveOriginalUsername(Boolean caseSensitive) {
        this.setBooleanConfig(CASE_SENSITIVE_ORIGINAL_USERNAME, caseSensitive);
    }

    public void setMinValidityToken(int minValidityToken) {
        this.getConfig().put(MIN_VALIDITY_TOKEN, Integer.toString(minValidityToken));
    }

    public IdentityProviderShowInAccountConsole getShowInAccountConsole() {
        return IdentityProviderShowInAccountConsole.valueOf(this.getConfig().getOrDefault(SHOW_IN_ACCOUNT_CONSOLE, IdentityProviderShowInAccountConsole.ALWAYS.name()));
    }

    public int getMinValidityToken() {
        String minValidityTokenString = this.getConfig().get(MIN_VALIDITY_TOKEN);
        if (minValidityTokenString != null) {
            try {
                int minValidityToken = Integer.parseInt(minValidityTokenString);
                if (minValidityToken > 0) {
                    return minValidityToken;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 5;
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.internalId);
        hash = 61 * hash + Objects.hashCode(this.alias);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IdentityProviderModel)) {
            return false;
        }
        return Objects.equals(this.getInternalId(), ((IdentityProviderModel)obj).getInternalId()) && Objects.equals(this.getAlias(), ((IdentityProviderModel)obj).getAlias());
    }

    private boolean getBooleanConfig(String key) {
        String value = this.getConfig().get(key);
        return value != null ? Boolean.parseBoolean(value) : Boolean.FALSE;
    }

    private void setBooleanConfig(String key, Boolean value) {
        this.getConfig().put(key, value != null ? String.valueOf(value) : null);
    }
}

