/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import org.keycloak.sdjwt.Disclosable;
import org.keycloak.sdjwt.SdJwtArrayElement;
import org.keycloak.sdjwt.SdJwtSalt;
import org.keycloak.sdjwt.SdJwtUtils;

public class UndisclosedArrayElement
extends Disclosable
implements SdJwtArrayElement {
    private final JsonNode arrayElement;

    private UndisclosedArrayElement(SdJwtSalt salt, JsonNode arrayElement) {
        super(salt);
        this.arrayElement = arrayElement;
    }

    @Override
    public JsonNode getVisibleValue(String hashAlg) {
        return SdJwtUtils.mapper.createObjectNode().put("...", this.getDisclosureDigest(hashAlg));
    }

    @Override
    Object[] toArray() {
        return new Object[]{this.getSaltAsString(), this.arrayElement};
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UndisclosedArrayElement)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UndisclosedArrayElement that = (UndisclosedArrayElement)o;
        return Objects.equals(this.arrayElement, that.arrayElement);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.arrayElement);
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SdJwtSalt salt;
        private JsonNode arrayElement;

        public Builder withSalt(SdJwtSalt salt) {
            this.salt = salt;
            return this;
        }

        public Builder withArrayElement(JsonNode arrayElement) {
            this.arrayElement = arrayElement;
            return this;
        }

        public UndisclosedArrayElement build() {
            this.arrayElement = Objects.requireNonNull(this.arrayElement, "arrayElement must not be null");
            this.salt = this.salt == null ? new SdJwtSalt(SdJwtUtils.randomSalt()) : this.salt;
            return new UndisclosedArrayElement(this.salt, this.arrayElement);
        }
    }
}

