/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.Map;
import org.hibernate.models.internal.AbstractModelsContext;
import org.hibernate.models.internal.AnnotationDescriptorRegistryStandard;
import org.hibernate.models.internal.ClassDetailsRegistryStandard;
import org.hibernate.models.internal.MutableAnnotationDescriptorRegistry;
import org.hibernate.models.internal.MutableClassDetailsRegistry;
import org.hibernate.models.serial.internal.StorableContextImpl;
import org.hibernate.models.serial.spi.StorableContext;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.RegistryPrimer;

public class BasicModelsContextImpl
extends AbstractModelsContext {
    private final AnnotationDescriptorRegistryStandard descriptorRegistry = new AnnotationDescriptorRegistryStandard(this);
    private final ClassDetailsRegistryStandard classDetailsRegistry;

    public BasicModelsContextImpl(ClassLoading classLoadingAccess, boolean trackImplementors, RegistryPrimer registryPrimer) {
        super(classLoadingAccess);
        this.classDetailsRegistry = new ClassDetailsRegistryStandard(trackImplementors, this);
        this.primeRegistries(registryPrimer);
    }

    private static boolean shouldTrackImplementors(Map<Object, Object> configValues) {
        Object value = configValues.get("hibernate.models.trackImplementors");
        if (value != null) {
            boolean bl;
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                bl = bool;
            } else {
                bl = Boolean.parseBoolean(value.toString());
            }
            return bl;
        }
        return false;
    }

    @Override
    public MutableAnnotationDescriptorRegistry getAnnotationDescriptorRegistry() {
        return this.descriptorRegistry;
    }

    @Override
    public MutableClassDetailsRegistry getClassDetailsRegistry() {
        return this.classDetailsRegistry;
    }

    @Override
    public StorableContext toStorableForm() {
        return new StorableContextImpl(this.classDetailsRegistry.isTrackingImplementors(), this.classDetailsRegistry.classDetailsMap, this.descriptorRegistry.descriptorMap);
    }
}

