/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.Config;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.requiredactions.UpdateEmail;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.AttributeChangeListener;
import org.keycloak.userprofile.EventAuditingAttributeChangeListener;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.ValidationException;

public class UpdateProfile
implements RequiredActionProvider,
RequiredActionFactory {
    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        context.challenge(this.createResponse(context, null, null));
    }

    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent();
        event.event(EventType.UPDATE_PROFILE).detail("context", UserProfileContext.UPDATE_PROFILE.name());
        MultivaluedHashMap formData = new MultivaluedHashMap(context.getHttpRequest().getDecodedFormParameters());
        UserModel user = context.getUser();
        String newEmail = (String)formData.getFirst((Object)"email");
        boolean isEmailUpdated = newEmail != null && !Optional.ofNullable(user.getEmail()).orElse("").equals(newEmail);
        RealmModel realm = context.getRealm();
        boolean isForceEmailVerification = isEmailUpdated && UpdateEmail.isVerifyEmailEnabled(realm);
        try {
            UserProfileProvider provider = (UserProfileProvider)context.getSession().getProvider(UserProfileProvider.class);
            UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, (Map)formData, user);
            if (isForceEmailVerification) {
                user.addRequiredAction(UserModel.RequiredAction.UPDATE_EMAIL);
            }
            profile.update(false, new AttributeChangeListener[]{new EventAuditingAttributeChangeListener(profile, event)});
            context.success();
        }
        catch (ValidationException pve) {
            List<FormMessage> errors = Validation.getFormErrorsFromValidation(pve.getErrors());
            context.challenge(this.createResponse(context, (MultivaluedMap<String, String>)formData, errors));
        }
    }

    protected UserModel.RequiredAction getResponseAction() {
        return UserModel.RequiredAction.UPDATE_PROFILE;
    }

    protected Response createResponse(RequiredActionContext context, MultivaluedMap<String, String> formData, List<FormMessage> errors) {
        LoginFormsProvider form = context.form();
        if (errors != null && !errors.isEmpty()) {
            form.setErrors(errors);
        }
        if (formData != null) {
            form = form.setFormData(formData);
        }
        form.setUser(context.getUser());
        return form.createResponse(this.getResponseAction());
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Update Profile";
    }

    public String getId() {
        return UserModel.RequiredAction.UPDATE_PROFILE.name();
    }
}

