/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.parser;

import java.util.StringTokenizer;
import org.ec4j.core.parser.Location;

public class Span {
    private final Location end;
    private final Location start;

    public static Builder builder() {
        return new Builder();
    }

    public static Span parse(String spanString) {
        StringTokenizer st = new StringTokenizer(spanString, "-");
        if (st.hasMoreTokens()) {
            Location start = Location.parse(st.nextToken());
            if (st.hasMoreTokens()) {
                Location end = Location.parse(st.nextToken());
                return new Span(start, end);
            }
        }
        throw new IllegalArgumentException("Cannot parse \"" + spanString + "\" into a " + Span.class.getName());
    }

    public Span(Location start, Location end) {
        this.start = start;
        this.end = end;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Span other = (Span)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }

    public Location getEnd() {
        return this.end;
    }

    public Location getStart() {
        return this.start;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.end == null ? 0 : this.end.hashCode());
        result2 = 31 * result2 + (this.start == null ? 0 : this.start.hashCode());
        return result2;
    }

    public String toString() {
        return this.start + " - " + this.end;
    }

    public static class ValueSpan
    extends Span {
        public static Span parse(String spanString) {
            Span s = Span.parse(spanString);
            return new ValueSpan(s.start, s.end);
        }

        private ValueSpan(Location start, Location end) {
            super(start, end);
        }
    }

    public static class GlobSpan
    extends Span {
        public static Span parse(String spanString) {
            Span s = Span.parse(spanString);
            return new GlobSpan(s.start, s.end);
        }

        private GlobSpan(Location start, Location end) {
            super(start, end);
        }
    }

    public static class NameSpan
    extends Span {
        public static Span parse(String spanString) {
            Span s = Span.parse(spanString);
            return new NameSpan(s.start, s.end);
        }

        private NameSpan(Location start, Location end) {
            super(start, end);
        }
    }

    public static class Builder {
        private Location end;
        private Location start;

        public NameSpan buildNameSpan() {
            return new NameSpan(this.start, this.end);
        }

        public GlobSpan buildGlobSpan() {
            return new GlobSpan(this.start, this.end);
        }

        public Span buildSpan() {
            return new Span(this.start, this.end);
        }

        public ValueSpan buildValueSpan() {
            return new ValueSpan(this.start, this.end);
        }

        public Builder end(Location end) {
            this.end = end;
            return this;
        }

        public Builder endIfNeeded(Location end) {
            if (this.end == null) {
                this.end = end;
            }
            return this;
        }

        public Builder start(Location start) {
            this.start = start;
            return this;
        }
    }
}

