/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.EventDestination;
import com.jetbrains.jdi.EventRequestManagerImpl;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JNITypeParser;
import com.jetbrains.jdi.MirrorImpl;
import com.jetbrains.jdi.Packet;
import com.jetbrains.jdi.PacketStream;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.Locatable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.MonitorContendedEnterEvent;
import com.sun.jdi.event.MonitorContendedEnteredEvent;
import com.sun.jdi.event.MonitorWaitEvent;
import com.sun.jdi.event.MonitorWaitedEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;

public class EventSetImpl
extends ArrayList<Event>
implements EventSet {
    private static final long serialVersionUID = -4857338819787924570L;
    private final VirtualMachineImpl vm;
    private Packet pkt;
    private byte suspendPolicy;
    private EventSetImpl internalEventSet;

    @Override
    public String toString() {
        String string = "event set, policy:" + this.suspendPolicy + ", count:" + this.size() + " = {";
        boolean first = true;
        for (Event event : this) {
            if (!first) {
                string = string + ", ";
            }
            string = string + event.toString();
            first = false;
        }
        string = string + "}";
        return string;
    }

    EventSetImpl(VirtualMachine aVm, Packet pkt) {
        this.vm = (VirtualMachineImpl)aVm;
        this.pkt = pkt;
    }

    EventSetImpl(VirtualMachine aVm, byte eventCmd) {
        this(aVm, null);
        this.suspendPolicy = 0;
        switch (eventCmd) {
            case 100: {
                this.addEvent(new VMDisconnectEventImpl());
                break;
            }
            default: {
                throw new InternalException("Bad singleton event code");
            }
        }
    }

    private void addEvent(EventImpl evt) {
        super.add(evt);
    }

    synchronized void build() {
        if (this.pkt == null) {
            return;
        }
        PacketStream ps = new PacketStream(this.vm, this.pkt);
        JDWP.Event.Composite compEvt = new JDWP.Event.Composite(this.vm, ps);
        this.suspendPolicy = compEvt.suspendPolicy;
        if ((this.vm.traceFlags & 4) != 0) {
            switch (this.suspendPolicy) {
                case 2: {
                    this.vm.printTrace("EventSet: SUSPEND_ALL");
                    break;
                }
                case 1: {
                    this.vm.printTrace("EventSet: SUSPEND_EVENT_THREAD");
                    break;
                }
                case 0: {
                    this.vm.printTrace("EventSet: SUSPEND_NONE");
                }
            }
        }
        ThreadReference fix6485605 = null;
        block12: for (int i = 0; i < compEvt.events.length; ++i) {
            EventImpl evt = this.createEvent(compEvt.events[i]);
            if ((this.vm.traceFlags & 4) != 0) {
                try {
                    this.vm.printTraceSafe(() -> "Event: " + evt);
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            switch (evt.destination()) {
                case UNKNOWN_EVENT: {
                    if (!(evt instanceof ThreadedEventImpl) || this.suspendPolicy != 1) continue block12;
                    fix6485605 = ((ThreadedEventImpl)evt).thread();
                    continue block12;
                }
                case CLIENT_EVENT: {
                    this.addEvent(evt);
                    continue block12;
                }
                case INTERNAL_EVENT: {
                    if (this.internalEventSet == null) {
                        this.internalEventSet = new EventSetImpl((VirtualMachine)this.vm, null);
                    }
                    this.internalEventSet.addEvent(evt);
                    continue block12;
                }
                default: {
                    throw new InternalException("Invalid event destination");
                }
            }
        }
        this.pkt = null;
        if (super.size() == 0) {
            if (this.suspendPolicy == 2) {
                this.vm.resume();
            } else if (this.suspendPolicy == 1 && fix6485605 != null) {
                fix6485605.resume();
            }
            this.suspendPolicy = 0;
        }
    }

    EventSet userFilter() {
        return this;
    }

    EventSet internalFilter() {
        return this.internalEventSet;
    }

    EventImpl createEvent(JDWP.Event.Composite.Events evt) {
        JDWP.Event.Composite.Events.EventsCommon comm = evt.aEventsCommon;
        switch (evt.eventKind) {
            case 6: {
                return new ThreadStartEventImpl((JDWP.Event.Composite.Events.ThreadStart)comm);
            }
            case 7: {
                return new ThreadDeathEventImpl((JDWP.Event.Composite.Events.ThreadDeath)comm);
            }
            case 4: {
                return new ExceptionEventImpl((JDWP.Event.Composite.Events.Exception)comm);
            }
            case 2: {
                return new BreakpointEventImpl((JDWP.Event.Composite.Events.Breakpoint)comm);
            }
            case 40: {
                return new MethodEntryEventImpl((JDWP.Event.Composite.Events.MethodEntry)comm);
            }
            case 41: {
                return new MethodExitEventImpl((JDWP.Event.Composite.Events.MethodExit)comm);
            }
            case 42: {
                return new MethodExitEventImpl((JDWP.Event.Composite.Events.MethodExitWithReturnValue)comm);
            }
            case 20: {
                return new AccessWatchpointEventImpl((JDWP.Event.Composite.Events.FieldAccess)comm);
            }
            case 21: {
                return new ModificationWatchpointEventImpl((JDWP.Event.Composite.Events.FieldModification)comm);
            }
            case 1: {
                return new StepEventImpl((JDWP.Event.Composite.Events.SingleStep)comm);
            }
            case 8: {
                return new ClassPrepareEventImpl((JDWP.Event.Composite.Events.ClassPrepare)comm);
            }
            case 9: {
                return new ClassUnloadEventImpl((JDWP.Event.Composite.Events.ClassUnload)comm);
            }
            case 43: {
                return new MonitorContendedEnterEventImpl((JDWP.Event.Composite.Events.MonitorContendedEnter)comm);
            }
            case 44: {
                return new MonitorContendedEnteredEventImpl((JDWP.Event.Composite.Events.MonitorContendedEntered)comm);
            }
            case 45: {
                return new MonitorWaitEventImpl((JDWP.Event.Composite.Events.MonitorWait)comm);
            }
            case 46: {
                return new MonitorWaitedEventImpl((JDWP.Event.Composite.Events.MonitorWaited)comm);
            }
            case 90: {
                return new VMStartEventImpl((JDWP.Event.Composite.Events.VMStart)comm);
            }
            case 99: {
                return new VMDeathEventImpl((JDWP.Event.Composite.Events.VMDeath)comm);
            }
        }
        System.err.println("Ignoring event cmd " + evt.eventKind + " from the VM");
        return null;
    }

    @Override
    public VirtualMachine virtualMachine() {
        return this.vm;
    }

    @Override
    public int suspendPolicy() {
        return EventRequestManagerImpl.JDWPtoJDISuspendPolicy(this.suspendPolicy);
    }

    private ThreadReference eventThread() {
        for (Event event : this) {
            if (!(event instanceof ThreadedEventImpl)) continue;
            return ((ThreadedEventImpl)event).thread();
        }
        return null;
    }

    @Override
    public void resume() {
        switch (this.suspendPolicy()) {
            case 2: {
                this.vm.resume();
                break;
            }
            case 1: {
                ThreadReference thread = this.eventThread();
                if (thread == null) {
                    throw new InternalException("Inconsistent suspend policy");
                }
                thread.resume();
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new InternalException("Invalid suspend policy");
            }
        }
    }

    public CompletableFuture<Void> resumeAsync() {
        switch (this.suspendPolicy()) {
            case 2: {
                return this.vm.resumeAsync();
            }
            case 1: {
                ThreadReference thread = this.eventThread();
                if (thread == null) {
                    throw new InternalException("Inconsistent suspend policy");
                }
                return ((ThreadReferenceImpl)thread).resumeAsync();
            }
            case 0: {
                return CompletableFuture.completedFuture(null);
            }
        }
        throw new InternalException("Invalid suspend policy");
    }

    @Override
    public Iterator<Event> iterator() {
        return new Itr();
    }

    @Override
    public EventIterator eventIterator() {
        return new Itr();
    }

    @Override
    public Spliterator<Event> spliterator() {
        return Spliterators.spliterator(this, 1);
    }

    @Override
    public boolean add(Event o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Event> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    class VMDisconnectEventImpl
    extends EventImpl
    implements VMDisconnectEvent {
        VMDisconnectEventImpl() {
            super((byte)100);
        }

        @Override
        String eventName() {
            return "VMDisconnectEvent";
        }
    }

    abstract class EventImpl
    extends MirrorImpl
    implements Event {
        private final byte eventCmd;
        private final int requestID;
        private final EventRequest request;

        protected EventImpl(JDWP.Event.Composite.Events.EventsCommon evt, int requestID) {
            super(EventSetImpl.this.vm);
            this.eventCmd = evt.eventKind();
            this.requestID = requestID;
            EventRequestManagerImpl ermi = EventSetImpl.this.vm.eventRequestManagerImpl();
            this.request = ermi.request(this.eventCmd, requestID);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        protected EventImpl(byte eventCmd) {
            super(EventSetImpl.this.vm);
            this.eventCmd = eventCmd;
            this.requestID = 0;
            this.request = null;
        }

        @Override
        public EventRequest request() {
            return this.request;
        }

        int requestID() {
            return this.requestID;
        }

        EventDestination destination() {
            if (this.requestID == 0) {
                return EventDestination.CLIENT_EVENT;
            }
            if (this.request == null) {
                EventRequestManagerImpl ermi = this.vm.getInternalEventRequestManager();
                if (ermi.request(this.eventCmd, this.requestID) != null) {
                    return EventDestination.INTERNAL_EVENT;
                }
                return EventDestination.UNKNOWN_EVENT;
            }
            if (this.request.isEnabled()) {
                return EventDestination.CLIENT_EVENT;
            }
            return EventDestination.UNKNOWN_EVENT;
        }

        abstract String eventName();

        @Override
        public String toString() {
            return this.eventName() + "(ER=" + this.requestID + ")";
        }
    }

    abstract class ThreadedEventImpl
    extends EventImpl {
        private final ThreadReference thread;

        ThreadedEventImpl(JDWP.Event.Composite.Events.EventsCommon evt, int requestID, ThreadReference thread) {
            super(evt, requestID);
            this.thread = thread;
        }

        public ThreadReference thread() {
            return this.thread;
        }

        @Override
        public String toString() {
            return this.eventName() + "(ER=" + this.requestID() + ") in thread " + this.thread.name();
        }
    }

    class ThreadStartEventImpl
    extends ThreadedEventImpl
    implements ThreadStartEvent {
        ThreadStartEventImpl(JDWP.Event.Composite.Events.ThreadStart evt) {
            super(evt, evt.requestID, evt.thread);
        }

        @Override
        String eventName() {
            return "ThreadStartEvent";
        }
    }

    class ThreadDeathEventImpl
    extends ThreadedEventImpl
    implements ThreadDeathEvent {
        ThreadDeathEventImpl(JDWP.Event.Composite.Events.ThreadDeath evt) {
            super(evt, evt.requestID, evt.thread);
        }

        @Override
        String eventName() {
            return "ThreadDeathEvent";
        }
    }

    class ExceptionEventImpl
    extends LocatableEventImpl
    implements ExceptionEvent {
        private final ObjectReference exception;
        private final Location catchLocation;

        ExceptionEventImpl(JDWP.Event.Composite.Events.Exception evt) {
            super(evt, evt.requestID, evt.thread, evt.location);
            this.exception = evt.exception;
            this.catchLocation = evt.catchLocation;
        }

        @Override
        public ObjectReference exception() {
            return this.exception;
        }

        @Override
        public Location catchLocation() {
            return this.catchLocation;
        }

        @Override
        String eventName() {
            return "ExceptionEvent";
        }
    }

    class BreakpointEventImpl
    extends LocatableEventImpl
    implements BreakpointEvent {
        BreakpointEventImpl(JDWP.Event.Composite.Events.Breakpoint evt) {
            super(evt, evt.requestID, evt.thread, evt.location);
        }

        @Override
        String eventName() {
            return "BreakpointEvent";
        }
    }

    class MethodEntryEventImpl
    extends LocatableEventImpl
    implements MethodEntryEvent {
        MethodEntryEventImpl(JDWP.Event.Composite.Events.MethodEntry evt) {
            super(evt, evt.requestID, evt.thread, evt.location);
        }

        @Override
        String eventName() {
            return "MethodEntryEvent";
        }
    }

    class MethodExitEventImpl
    extends LocatableEventImpl
    implements MethodExitEvent {
        private Value returnVal;

        MethodExitEventImpl(JDWP.Event.Composite.Events.MethodExit evt) {
            super(evt, evt.requestID, evt.thread, evt.location);
            this.returnVal = null;
        }

        MethodExitEventImpl(JDWP.Event.Composite.Events.MethodExitWithReturnValue evt) {
            super(evt, evt.requestID, evt.thread, evt.location);
            this.returnVal = null;
            this.returnVal = evt.value;
        }

        @Override
        String eventName() {
            return "MethodExitEvent";
        }

        @Override
        public Value returnValue() {
            if (!this.vm.canGetMethodReturnValues()) {
                throw new UnsupportedOperationException("target does not support return values in MethodExit events");
            }
            return this.returnVal;
        }
    }

    class AccessWatchpointEventImpl
    extends WatchpointEventImpl
    implements AccessWatchpointEvent {
        AccessWatchpointEventImpl(JDWP.Event.Composite.Events.FieldAccess evt) {
            super(evt, evt.requestID, evt.thread, evt.location, evt.refTypeTag, evt.typeID, evt.fieldID, evt.object);
        }

        @Override
        String eventName() {
            return "AccessWatchpoint";
        }
    }

    class ModificationWatchpointEventImpl
    extends WatchpointEventImpl
    implements ModificationWatchpointEvent {
        final Value newValue;

        ModificationWatchpointEventImpl(JDWP.Event.Composite.Events.FieldModification evt) {
            super(evt, evt.requestID, evt.thread, evt.location, evt.refTypeTag, evt.typeID, evt.fieldID, evt.object);
            this.newValue = evt.valueToBe;
        }

        @Override
        public Value valueToBe() {
            return this.newValue;
        }

        @Override
        String eventName() {
            return "ModificationWatchpoint";
        }
    }

    class StepEventImpl
    extends LocatableEventImpl
    implements StepEvent {
        StepEventImpl(JDWP.Event.Composite.Events.SingleStep evt) {
            super(evt, evt.requestID, evt.thread, evt.location);
        }

        @Override
        String eventName() {
            return "StepEvent";
        }
    }

    class ClassPrepareEventImpl
    extends ThreadedEventImpl
    implements ClassPrepareEvent {
        private final ReferenceType referenceType;

        ClassPrepareEventImpl(JDWP.Event.Composite.Events.ClassPrepare evt) {
            super(evt, evt.requestID, evt.thread);
            this.referenceType = this.vm.referenceType(evt.typeID, evt.refTypeTag, evt.signature);
            ((ReferenceTypeImpl)this.referenceType).setStatus(evt.status);
        }

        @Override
        public ReferenceType referenceType() {
            return this.referenceType;
        }

        @Override
        String eventName() {
            return "ClassPrepareEvent";
        }
    }

    class ClassUnloadEventImpl
    extends EventImpl
    implements ClassUnloadEvent {
        private final String classSignature;

        ClassUnloadEventImpl(JDWP.Event.Composite.Events.ClassUnload evt) {
            super(evt, evt.requestID);
            this.classSignature = evt.signature;
        }

        @Override
        public String className() {
            return JNITypeParser.convertSignatureToClassname(this.classSignature);
        }

        @Override
        public String classSignature() {
            return this.classSignature;
        }

        @Override
        String eventName() {
            return "ClassUnloadEvent";
        }
    }

    class MonitorContendedEnterEventImpl
    extends LocatableEventImpl
    implements MonitorContendedEnterEvent {
        private final ObjectReference monitor;

        MonitorContendedEnterEventImpl(JDWP.Event.Composite.Events.MonitorContendedEnter evt) {
            super(evt, evt.requestID, evt.thread, evt.location);
            this.monitor = evt.object;
        }

        @Override
        String eventName() {
            return "MonitorContendedEnter";
        }

        @Override
        public ObjectReference monitor() {
            return this.monitor;
        }
    }

    class MonitorContendedEnteredEventImpl
    extends LocatableEventImpl
    implements MonitorContendedEnteredEvent {
        private final ObjectReference monitor;

        MonitorContendedEnteredEventImpl(JDWP.Event.Composite.Events.MonitorContendedEntered evt) {
            super(evt, evt.requestID, evt.thread, evt.location);
            this.monitor = evt.object;
        }

        @Override
        String eventName() {
            return "MonitorContendedEntered";
        }

        @Override
        public ObjectReference monitor() {
            return this.monitor;
        }
    }

    class MonitorWaitEventImpl
    extends LocatableEventImpl
    implements MonitorWaitEvent {
        private final ObjectReference monitor;
        private final long timeout;

        MonitorWaitEventImpl(JDWP.Event.Composite.Events.MonitorWait evt) {
            super(evt, evt.requestID, evt.thread, evt.location);
            this.monitor = evt.object;
            this.timeout = evt.timeout;
        }

        @Override
        String eventName() {
            return "MonitorWait";
        }

        @Override
        public ObjectReference monitor() {
            return this.monitor;
        }

        @Override
        public long timeout() {
            return this.timeout;
        }
    }

    class MonitorWaitedEventImpl
    extends LocatableEventImpl
    implements MonitorWaitedEvent {
        private final ObjectReference monitor;
        private final boolean timed_out;

        MonitorWaitedEventImpl(JDWP.Event.Composite.Events.MonitorWaited evt) {
            super(evt, evt.requestID, evt.thread, evt.location);
            this.monitor = evt.object;
            this.timed_out = evt.timed_out;
        }

        @Override
        String eventName() {
            return "MonitorWaited";
        }

        @Override
        public ObjectReference monitor() {
            return this.monitor;
        }

        @Override
        public boolean timedout() {
            return this.timed_out;
        }
    }

    class VMStartEventImpl
    extends ThreadedEventImpl
    implements VMStartEvent {
        VMStartEventImpl(JDWP.Event.Composite.Events.VMStart evt) {
            super(evt, evt.requestID, evt.thread);
        }

        @Override
        String eventName() {
            return "VMStartEvent";
        }
    }

    class VMDeathEventImpl
    extends EventImpl
    implements VMDeathEvent {
        VMDeathEventImpl(JDWP.Event.Composite.Events.VMDeath evt) {
            super(evt, evt.requestID);
        }

        @Override
        String eventName() {
            return "VMDeathEvent";
        }
    }

    public class Itr
    implements EventIterator {
        int cursor = 0;

        @Override
        public boolean hasNext() {
            return this.cursor != EventSetImpl.this.size();
        }

        @Override
        public Event next() {
            try {
                Event nxt = (Event)EventSetImpl.this.get(this.cursor);
                ++this.cursor;
                return nxt;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public Event nextEvent() {
            return this.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    abstract class WatchpointEventImpl
    extends LocatableEventImpl
    implements WatchpointEvent {
        private final ReferenceTypeImpl refType;
        private final long fieldID;
        private final ObjectReference object;
        private Field field;

        WatchpointEventImpl(JDWP.Event.Composite.Events.EventsCommon evt, int requestID, ThreadReference thread, Location location, byte refTypeTag, long typeID, long fieldID, ObjectReference object) {
            super(evt, requestID, thread, location);
            this.field = null;
            this.refType = this.vm.referenceType(typeID, refTypeTag);
            this.fieldID = fieldID;
            this.object = object;
        }

        @Override
        public Field field() {
            if (this.field == null) {
                this.field = this.refType.getFieldMirror(this.fieldID);
            }
            return this.field;
        }

        @Override
        public ObjectReference object() {
            return this.object;
        }

        @Override
        public Value valueCurrent() {
            if (this.object == null) {
                return this.refType.getValue(this.field());
            }
            return this.object.getValue(this.field());
        }
    }

    abstract class LocatableEventImpl
    extends ThreadedEventImpl
    implements Locatable {
        private final Location location;

        LocatableEventImpl(JDWP.Event.Composite.Events.EventsCommon evt, int requestID, ThreadReference thread, Location location) {
            super(evt, requestID, thread);
            this.location = location;
        }

        @Override
        public Location location() {
            return this.location;
        }

        public Method method() {
            return this.location.method();
        }

        @Override
        public String toString() {
            return this.eventName() + "(ER=" + this.requestID() + ")@" + (this.location() == null ? " null" : this.location().toString()) + " in thread " + this.thread().name();
        }
    }
}

