/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.migration.KotlinMigrationBundle;
import org.jetbrains.kotlin.idea.migration.MigrationInfo;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrationFix;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\r"}, d2={"createMigrationProfile", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "managerEx", "Lcom/intellij/codeInspection/ex/InspectionManagerEx;", "psiElement", "Lcom/intellij/psi/PsiElement;", "migrationInfo", "Lorg/jetbrains/kotlin/idea/migration/MigrationInfo;", "applicableMigrationToolExists", "", "applicableMigrationToolsImpl", "", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "kotlin.migration"})
public final class KotlinMigrationProfileKt {
    @NotNull
    public static final InspectionProfileImpl createMigrationProfile(@NotNull InspectionManagerEx managerEx, @Nullable PsiElement psiElement, @Nullable MigrationInfo migrationInfo) {
        Intrinsics.checkNotNullParameter((Object)managerEx, (String)"managerEx");
        InspectionProfileImpl inspectionProfileImpl = InspectionProfileManager.getInstance().getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
        InspectionProfileImpl rootProfile = inspectionProfileImpl;
        List<InspectionToolWrapper<?, ?>> migrationFixWrappers = KotlinMigrationProfileKt.applicableMigrationToolsImpl(migrationInfo);
        LinkedHashSet allWrappers = new LinkedHashSet();
        for (InspectionToolWrapper<?, ?> toolWrapper : migrationFixWrappers) {
            allWrappers.add(toolWrapper);
            rootProfile.collectDependentInspections(toolWrapper, (Set)allWrappers, managerEx.getProject());
        }
        String string = KotlinMigrationBundle.message("inspection.migration.profile.name", new Object[0]);
        Project project = managerEx.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        InspectionProfileImpl model2 = InspectionProfileKt.createSimple((String)string, (Project)project, migrationFixWrappers);
        try {
            Element element = new Element("toCopy");
            for (InspectionToolWrapper<?, ?> wrapper : migrationFixWrappers) {
                InspectionToolWrapper tw;
                wrapper.getTool().writeSettings(element);
                Intrinsics.checkNotNull((Object)(psiElement == null ? model2.getInspectionTool(wrapper.getShortName(), managerEx.getProject()) : model2.getInspectionTool(wrapper.getShortName(), psiElement)));
                tw = tw;
                tw.getTool().readSettings(element);
            }
        }
        catch (WriteExternalException writeExternalException) {
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        return model2;
    }

    public static /* synthetic */ InspectionProfileImpl createMigrationProfile$default(InspectionManagerEx inspectionManagerEx, PsiElement psiElement, MigrationInfo migrationInfo, int n, Object object) {
        if ((n & 4) != 0) {
            migrationInfo = null;
        }
        return KotlinMigrationProfileKt.createMigrationProfile(inspectionManagerEx, psiElement, migrationInfo);
    }

    public static final boolean applicableMigrationToolExists(@NotNull MigrationInfo migrationInfo) {
        Intrinsics.checkNotNullParameter((Object)migrationInfo, (String)"migrationInfo");
        return !((Collection)KotlinMigrationProfileKt.applicableMigrationToolsImpl(migrationInfo)).isEmpty();
    }

    private static final List<InspectionToolWrapper<?, ?>> applicableMigrationToolsImpl(MigrationInfo migrationInfo) {
        InspectionProfileImpl inspectionProfileImpl = InspectionProfileManager.getInstance().getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
        InspectionProfileImpl rootProfile = inspectionProfileImpl;
        List list2 = rootProfile.getAllTools();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllTools(...)");
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), KotlinMigrationProfileKt::applicableMigrationToolsImpl$lambda$0), arg_0 -> KotlinMigrationProfileKt.applicableMigrationToolsImpl$lambda$1(migrationInfo, arg_0)));
    }

    private static final InspectionToolWrapper applicableMigrationToolsImpl$lambda$0(ScopeToolState it) {
        return it.getTool();
    }

    private static final boolean applicableMigrationToolsImpl$lambda$1(MigrationInfo $migrationInfo, InspectionToolWrapper toolWrapper) {
        Intrinsics.checkNotNullParameter((Object)toolWrapper, (String)"toolWrapper");
        InspectionProfileEntry inspectionProfileEntry = toolWrapper.getTool();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileEntry, (String)"getTool(...)");
        InspectionProfileEntry tool = inspectionProfileEntry;
        return tool instanceof MigrationFix && ($migrationInfo == null || ((MigrationFix)tool).isApplicable($migrationInfo));
    }
}

