/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.execution.junit.JUnit3Framework;
import com.intellij.execution.junit.JUnit4Framework;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class TestClassFilter
implements ClassFilter.ClassFilterWithScope {
    @Nullable
    private final PsiClass myBase;
    private final Project myProject;
    private final GlobalSearchScope myScope;

    private TestClassFilter(@Nullable PsiClass base, GlobalSearchScope scope) {
        this.myBase = base;
        this.myProject = scope.getProject();
        this.myScope = scope;
    }

    public PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myProject);
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean isAccepted(PsiClass aClass) {
        return (Boolean)ReadAction.compute(() -> (Boolean)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
            if (TestClassFilter.isTopMostTestClass(aClass)) {
                CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)this.getProject());
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)aClass);
                if (virtualFile == null) {
                    return false;
                }
                return !compilerConfiguration.isExcludedFromCompilation(virtualFile) && !ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.RESOURCES);
            }
            return false;
        }));
    }

    private static boolean isTopMostTestClass(PsiClass psiClass) {
        if (psiClass.getQualifiedName() == null) {
            return false;
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)true)) {
            return false;
        }
        TestFramework framework = TestFrameworks.detectFramework((PsiClass)psiClass);
        if (framework instanceof JUnit4Framework || framework instanceof JUnit3Framework) {
            return framework.isTestClass((PsiElement)psiClass);
        }
        return false;
    }

    @NotNull
    public TestClassFilter intersectionWith(GlobalSearchScope scope) {
        return new TestClassFilter(this.myBase, this.myScope.intersectWith(scope));
    }

    @NotNull
    public static TestClassFilter create(SourceScope sourceScope, Module module) throws JUnitUtil.NoJUnitException {
        PsiClass testCase = TestClassFilter.getTestCase(sourceScope, module);
        return new TestClassFilter(testCase, sourceScope.getGlobalSearchScope());
    }

    @NotNull
    private static PsiClass getTestCase(SourceScope sourceScope, Module module) throws JUnitUtil.NoJUnitException {
        if (sourceScope == null) {
            throw new JUnitUtil.NoJUnitException();
        }
        PsiClass psiClass = (PsiClass)ReadAction.compute(() -> module == null ? JUnitUtil.getTestCaseClass((SourceScope)sourceScope) : JUnitUtil.getTestCaseClass((Module)module));
        if (psiClass == null) {
            TestClassFilter.$$$reportNull$$$0(0);
        }
        return psiClass;
    }

    public static TestClassFilter create(SourceScope sourceScope, Module module, String pattern) throws JUnitUtil.NoJUnitException {
        PsiClass testCase = TestClassFilter.getTestCase(sourceScope, module);
        final Predicate<String> predicate = TestClassFilter.getClassNamePredicate(pattern);
        return new TestClassFilter(testCase, sourceScope.getGlobalSearchScope()){

            @Override
            public boolean isAccepted(PsiClass aClass) {
                if (super.isAccepted(aClass)) {
                    String qualifiedName = (String)ReadAction.compute(() -> aClass.getQualifiedName());
                    return predicate.test(qualifiedName);
                }
                return false;
            }
        };
    }

    private static Pattern getCompilePattern(String pattern) {
        Pattern compilePattern;
        try {
            compilePattern = Pattern.compile(pattern.trim());
        }
        catch (PatternSyntaxException e) {
            compilePattern = null;
        }
        return compilePattern;
    }

    public static Predicate<String> getClassNamePredicate(String pattern) {
        String[] patterns = pattern.split("\\|\\|");
        ArrayList<Pattern> compilePatterns = new ArrayList<Pattern>();
        for (String p : patterns) {
            Pattern compilePattern = TestClassFilter.getCompilePattern(p);
            if (compilePattern == null) continue;
            compilePatterns.add(compilePattern);
        }
        return qualifiedName -> {
            for (Pattern compilePattern : compilePatterns) {
                if (!compilePattern.matcher((CharSequence)qualifiedName).matches()) continue;
                return true;
            }
            return false;
        };
    }

    public GlobalSearchScope getScope() {
        return this.myScope;
    }

    @Nullable
    public PsiClass getBase() {
        return this.myBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestClassFilter", "getTestCase"));
    }
}

