/*
 * Decompiled with CFR 0.152.
 */
package ghidra.service.graph;

import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.DefaultGraphType;

public class AttributedGraph
extends AbstractBaseGraph<AttributedVertex, AttributedEdge> {
    public static final String WEIGHT = "Weight";
    private Map<String, AttributedVertex> vertexMap = new HashMap<String, AttributedVertex>();
    private final boolean collapseDuplicateEdges;
    private String name;
    private GraphType type;
    private String description;

    public AttributedGraph(String name, GraphType type) {
        this(name, type, name, true);
    }

    public AttributedGraph(String name, GraphType type, String description) {
        this(name, type, description, true);
    }

    public AttributedGraph(String name, GraphType type, String description, boolean collapseDuplicateEdges) {
        super((Supplier)new VertexSupplier(), (Supplier)new EdgeSupplier(), (org.jgrapht.GraphType)DefaultGraphType.directedPseudograph());
        this.name = name;
        this.type = type;
        this.description = description;
        this.collapseDuplicateEdges = collapseDuplicateEdges;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public GraphType getGraphType() {
        return this.type;
    }

    public AttributedVertex addVertex(String id) {
        return this.addVertex(id, id);
    }

    public AttributedVertex addVertex(String id, String vertexName) {
        if (this.vertexMap.containsKey(id)) {
            AttributedVertex vertex = this.vertexMap.get(id);
            vertex.setName(vertexName);
            return vertex;
        }
        AttributedVertex newVertex = new AttributedVertex(id, vertexName);
        this.addVertex(newVertex);
        return newVertex;
    }

    public AttributedVertex addVertex() {
        AttributedVertex vertex = (AttributedVertex)super.addVertex();
        this.vertexMap.put(vertex.getId(), vertex);
        return vertex;
    }

    public boolean addVertex(AttributedVertex vertex) {
        if (super.addVertex((Object)vertex)) {
            this.vertexMap.put(vertex.getId(), vertex);
            return true;
        }
        return false;
    }

    public AttributedEdge addEdge(AttributedVertex source, AttributedVertex target, String edgeId) {
        AttributedEdge basicEdge = new AttributedEdge(edgeId);
        this.addEdge(source, target, basicEdge);
        return basicEdge;
    }

    public boolean addEdge(AttributedVertex source, AttributedVertex target, AttributedEdge edge) {
        AttributedEdge existingEdge;
        this.ensureInGraph(source);
        this.ensureInGraph(target);
        if (this.collapseDuplicateEdges && (existingEdge = (AttributedEdge)this.getEdge(source, target)) != null) {
            AttributedGraph.incrementWeightProperty(existingEdge);
            return true;
        }
        return super.addEdge((Object)source, (Object)target, (Object)edge);
    }

    public AttributedEdge addEdge(AttributedVertex source, AttributedVertex target) {
        AttributedEdge edge;
        this.ensureInGraph(source);
        this.ensureInGraph(target);
        if (this.collapseDuplicateEdges && (edge = (AttributedEdge)this.getEdge(source, target)) != null) {
            AttributedGraph.incrementWeightProperty(edge);
            return edge;
        }
        return (AttributedEdge)super.addEdge((Object)source, (Object)target);
    }

    public int getEdgeCount() {
        return this.edgeSet().size();
    }

    public int getVertexCount() {
        return this.vertexSet().size();
    }

    public AttributedVertex getVertex(String vertexId) {
        return this.vertexMap.get(vertexId);
    }

    private void ensureInGraph(AttributedVertex vertex) {
        if (!this.containsVertex(vertex)) {
            this.addVertex(vertex);
        }
    }

    private static void incrementWeightProperty(AttributedEdge edge) {
        if (edge.hasAttribute(WEIGHT)) {
            String weightString = edge.getAttribute(WEIGHT);
            edge.setAttribute(WEIGHT, AttributedGraph.incrementWeightStringValue(weightString));
        } else {
            edge.setAttribute(WEIGHT, "2");
        }
    }

    private static String incrementWeightStringValue(String value) {
        int weight = Integer.parseInt(value);
        return Integer.toString(++weight);
    }

    private static class VertexSupplier
    implements Supplier<AttributedVertex> {
        long nextId = 1L;

        private VertexSupplier() {
        }

        @Override
        public AttributedVertex get() {
            return new AttributedVertex(Long.toString(this.nextId++));
        }
    }

    private static class EdgeSupplier
    implements Supplier<AttributedEdge> {
        long nextId = 1L;

        private EdgeSupplier() {
        }

        @Override
        public AttributedEdge get() {
            return new AttributedEdge(Long.toString(this.nextId++));
        }
    }
}

