/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.layout;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.LayoutListener;
import ghidra.graph.viewer.layout.LayoutPositions;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.graph.viewer.renderer.ArticulatedEdgeRenderer;
import ghidra.graph.viewer.shape.ArticulatedEdgeTransformer;
import ghidra.util.exception.AssertException;
import ghidra.util.task.TaskMonitor;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class JungWrappingVisualGraphLayoutAdapter<V extends VisualVertex, E extends VisualEdge<V>>
implements VisualGraphLayout<V, E> {
    private ArticulatedEdgeTransformer<V, E> edgeShapeTransformer = new ArticulatedEdgeTransformer();
    private ArticulatedEdgeRenderer<V, E> edgeRenderer = new ArticulatedEdgeRenderer();
    private List<WeakReference<LayoutListener<V, E>>> listeners = new ArrayList<WeakReference<LayoutListener<V, E>>>();
    protected Layout<V, E> delegate;

    public JungWrappingVisualGraphLayoutAdapter(Layout<V, E> jungLayout) {
        this.delegate = jungLayout;
    }

    public void initialize() {
        this.delegate.initialize();
    }

    public void reset() {
        this.delegate.reset();
    }

    @Override
    public LayoutPositions<V, E> calculateLocations(VisualGraph<V, E> graph, TaskMonitor monitor) {
        HashMap<VisualVertex, Point2D> vertexLocations = new HashMap<VisualVertex, Point2D>();
        Collection vertices = graph.getVertices();
        for (VisualVertex v : vertices) {
            Point2D location = (Point2D)this.delegate.apply((Object)v);
            vertexLocations.put(v, location);
        }
        HashMap edgeErticulations = new HashMap();
        Collection edges = graph.getEdges();
        for (VisualEdge edge : edges) {
            ArrayList newArticulations = new ArrayList();
            edgeErticulations.put(edge, newArticulations);
        }
        return LayoutPositions.createNewPositions(vertexLocations, edgeErticulations);
    }

    public JungWrappingVisualGraphLayoutAdapter cloneLayout(VisualGraph<V, E> newGraph) {
        Layout<V, E> newJungLayout = this.cloneJungLayout(newGraph);
        return new JungWrappingVisualGraphLayoutAdapter<V, E>(newJungLayout);
    }

    protected Layout<V, E> cloneJungLayout(VisualGraph<V, E> newGraph) {
        Class delegateClass = this.delegate.getClass();
        try {
            Constructor constructor = delegateClass.getConstructor(Graph.class);
            Layout layout = (Layout)constructor.newInstance(newGraph);
            return layout;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to clone jung graph: " + String.valueOf(this.delegate.getClass()), e);
        }
    }

    @Override
    public boolean usesEdgeArticulations() {
        return false;
    }

    @Override
    public void dispose() {
        this.listeners.clear();
    }

    public Graph<V, E> getGraph() {
        return this.delegate.getGraph();
    }

    public Dimension getSize() {
        return this.delegate.getSize();
    }

    public boolean isLocked(V v) {
        return this.delegate.isLocked(v);
    }

    public void lock(V v, boolean lock) {
        this.delegate.lock(v, lock);
    }

    public void setGraph(Graph<V, E> graph) {
        this.delegate.setGraph(graph);
    }

    public void setInitializer(Function<V, Point2D> t) {
        this.delegate.setInitializer(t);
    }

    public void setSize(Dimension d) {
        this.delegate.setSize(d);
        this.syncVertexLocationsToLayout();
    }

    private void syncVertexLocationsToLayout() {
        Graph<V, E> g = this.getGraph();
        Collection vertices = g.getVertices();
        for (VisualVertex v : vertices) {
            v.setLocation(this.apply((V)v));
        }
    }

    public Point2D apply(V v) {
        return (Point2D)this.delegate.apply(v);
    }

    @Override
    public BasicEdgeRenderer<V, E> getEdgeRenderer() {
        return this.edgeRenderer;
    }

    @Override
    public Function<E, Shape> getEdgeShapeTransformer() {
        return this.edgeShapeTransformer;
    }

    @Override
    public Renderer.EdgeLabel<V, E> getEdgeLabelRenderer() {
        return null;
    }

    @Override
    public void addLayoutListener(LayoutListener<V, E> listener) {
        Class<?> listenerClass = listener.getClass();
        if (listenerClass.isAnonymousClass()) {
            throw new AssertException("Cannot add anonymous listeners to a weak collection!");
        }
        this.listeners.add(new WeakReference<LayoutListener<V, E>>(listener));
    }

    @Override
    public void removeLayoutListener(LayoutListener<V, E> listener) {
        Iterator<WeakReference<LayoutListener<V, E>>> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WeakReference<LayoutListener<V, E>> reference = iterator.next();
            LayoutListener layoutListener = (LayoutListener)reference.get();
            if (layoutListener == null) {
                iterator.remove();
            }
            if (layoutListener != listener) continue;
            iterator.remove();
        }
    }

    private void fireVertexLocationChanged(V vertex, Point2D point, LayoutListener.ChangeType type) {
        Iterator<WeakReference<LayoutListener<V, E>>> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WeakReference<LayoutListener<V, E>> reference = iterator.next();
            LayoutListener layoutListener = (LayoutListener)reference.get();
            if (layoutListener == null) {
                iterator.remove();
                continue;
            }
            layoutListener.vertexLocationChanged(vertex, point, type);
        }
    }

    public void setLocation(V v, Point2D location) {
        this.delegate.setLocation(v, location);
        this.fireVertexLocationChanged(v, location, LayoutListener.ChangeType.USER);
    }

    @Override
    public void setLocation(V v, Point2D location, LayoutListener.ChangeType changeType) {
        this.delegate.setLocation(v, location);
        this.fireVertexLocationChanged(v, location, changeType);
    }

    @Override
    public VisualGraph<V, E> getVisualGraph() {
        return (VisualGraph)this.getGraph();
    }
}

