/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.btree;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.ios.btree.BTreeNodeDescriptor;
import ghidra.file.formats.ios.decmpfs.DecmpfsHeader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class BTreeNodeRecord
implements StructConverter {
    private int unknown0;
    private int fileID;
    private int unknown2;
    private String type;
    private int unknown3;
    private int unknown4;
    private int unknown5;
    private int recordLength;
    private short _typeLength;
    private BTreeNodeDescriptor _descriptor;
    private DecmpfsHeader _decmpfsHeader;
    private long _offset;

    BTreeNodeRecord(BinaryReader reader, BTreeNodeDescriptor descriptor) throws IOException {
        this._offset = reader.getPointerIndex();
        this.unknown0 = reader.readNextInt();
        this.fileID = reader.readNextInt();
        this.unknown2 = reader.readNextInt();
        this._typeLength = reader.readNextShort();
        this.type = this.readType(reader);
        this.unknown3 = reader.readNextInt();
        switch (descriptor.getKind()) {
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            case -1: {
                this.unknown4 = reader.readNextInt();
                this.unknown5 = reader.readNextInt();
                this.recordLength = reader.readNextInt();
                break;
            }
        }
        this._descriptor = descriptor;
        if (descriptor.getKind() == -1) {
            if (this.getType().equals("com.apple.decmpfs")) {
                this._decmpfsHeader = new DecmpfsHeader(reader, this.getRecordLength());
            } else if (this.getType().equals("com.apple.system.Security")) {
                // empty if block
            }
        }
    }

    private String readType(BinaryReader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this._typeLength; ++i) {
            reader.readNextByte();
            buffer.append((char)reader.readNextByte());
        }
        return buffer.toString();
    }

    public String getType() {
        return this.type;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public int getUnknown0() {
        return this.unknown0;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    public int getUnknown3() {
        return this.unknown3;
    }

    public int getUnknown4() {
        return this.unknown4;
    }

    public int getUnknown5() {
        return this.unknown5;
    }

    public int getFileID() {
        return this.fileID;
    }

    public DecmpfsHeader getDecmpfsHeader() {
        return this._decmpfsHeader;
    }

    public long getRecordOffset() {
        return this._offset;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = StructConverterUtil.parseName(BTreeNodeRecord.class);
        StructureDataType struct = new StructureDataType(name, 0);
        struct.add(DWORD, "unknown0", null);
        struct.add(DWORD, "fileID", null);
        struct.add(DWORD, "unknown2", null);
        struct.add(WORD, "typeLength", null);
        struct.add(UTF16, this._typeLength * 2, "type", null);
        struct.add(DWORD, "unknown3", null);
        if (this._descriptor.getKind() == -1) {
            struct.add(DWORD, "unknown4", null);
            struct.add(DWORD, "unknown5", null);
            struct.add(DWORD, "recordLength", null);
        }
        try {
            struct.setName(name + "_" + struct.getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return struct;
    }
}

