/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.util;

import java.util.DoubleSummaryStatistics;
import org.jungrapht.visualization.layout.algorithms.util.PointConsumer;
import org.jungrapht.visualization.layout.model.Point;

public class PointSummaryStatistics
implements PointConsumer {
    private DoubleSummaryStatistics xValues;
    private DoubleSummaryStatistics yValues;

    public PointSummaryStatistics() {
        this.xValues = new DoubleSummaryStatistics();
        this.yValues = new DoubleSummaryStatistics();
    }

    public PointSummaryStatistics(int count, int min, int max, int sum) throws IllegalArgumentException {
        this.xValues = new DoubleSummaryStatistics(count, min, max, sum);
        this.yValues = new DoubleSummaryStatistics(count, min, max, sum);
    }

    @Override
    public void accept(Point p) {
        this.xValues.accept(p.x);
        this.yValues.accept(p.y);
    }

    public void combine(PointSummaryStatistics other) {
        this.xValues.combine(other.xValues);
        this.yValues.combine(other.yValues);
    }

    public final long getCount() {
        return this.xValues.getCount();
    }

    public final Point getSum() {
        return Point.of((int)this.xValues.getSum(), (int)this.yValues.getSum());
    }

    public final Point getMin() {
        return Point.of(this.xValues.getMin(), this.yValues.getMin());
    }

    public final Point getMax() {
        return Point.of(this.xValues.getMax(), this.yValues.getMax());
    }

    public final Point getAverage() {
        return Point.of((int)this.xValues.getAverage(), (int)this.yValues.getAverage());
    }

    public String toString() {
        return "DimensionSummaryStatistics{xValues=" + this.xValues + ", heights=" + this.yValues + "}";
    }
}

