/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.matcher;

import ghidra.features.base.memsearch.bytesequence.ExtendedByteSequence;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.UnsupportedOperationException;

public class RegExByteMatcher
extends ByteMatcher {
    private final Pattern pattern;

    public RegExByteMatcher(String input, SearchSettings settings) {
        super(input, settings);
        this.pattern = Pattern.compile(input, 32);
    }

    @Override
    public Iterable<ByteMatcher.ByteMatch> match(ExtendedByteSequence byteSequence) {
        return new PatternMatchIterator(this, byteSequence);
    }

    @Override
    public String getDescription() {
        return "Reg Ex";
    }

    @Override
    public String getToolTip() {
        return null;
    }

    private class PatternMatchIterator
    implements Iterable<ByteMatcher.ByteMatch>,
    Iterator<ByteMatcher.ByteMatch> {
        private Matcher matcher;
        private ByteMatcher.ByteMatch nextMatch;
        private ExtendedByteSequence byteSequence;

        public PatternMatchIterator(RegExByteMatcher regExByteMatcher, ExtendedByteSequence byteSequence) {
            this.byteSequence = byteSequence;
            this.matcher = regExByteMatcher.pattern.matcher(new ByteCharSequence(regExByteMatcher, byteSequence));
            this.nextMatch = this.findNextMatch();
        }

        @Override
        public boolean hasNext() {
            return this.nextMatch != null;
        }

        @Override
        public ByteMatcher.ByteMatch next() {
            if (this.nextMatch == null) {
                return null;
            }
            ByteMatcher.ByteMatch returnValue = this.nextMatch;
            this.nextMatch = this.findNextMatch();
            return returnValue;
        }

        @Override
        public Iterator<ByteMatcher.ByteMatch> iterator() {
            return this;
        }

        private ByteMatcher.ByteMatch findNextMatch() {
            if (!this.matcher.find()) {
                return null;
            }
            int start = this.matcher.start();
            int end = this.matcher.end();
            if (start >= this.byteSequence.getLength()) {
                return null;
            }
            return new ByteMatcher.ByteMatch(start, end - start);
        }
    }

    private class ByteCharSequence
    implements CharSequence {
        private ExtendedByteSequence byteSequence;

        ByteCharSequence(RegExByteMatcher regExByteMatcher, ExtendedByteSequence byteSequence) {
            this.byteSequence = byteSequence;
        }

        @Override
        public int length() {
            return this.byteSequence.getExtendedLength();
        }

        @Override
        public char charAt(int index) {
            byte b = this.byteSequence.getByte(index);
            return (char)(b & 0xFF);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }
    }
}

