/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.combiner;

import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.program.model.address.Address;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public enum Combiner {
    REPLACE("New", Combiner::replace),
    UNION("Add To", Combiner::union),
    INTERSECT("Intersect", Combiner::intersect),
    XOR("Xor", Combiner::xor),
    A_MINUS_B("A-B", Combiner::subtract),
    B_MINUS_A("B-A", Combiner::reverseSubtract);

    private String name;
    private BiFunction<List<MemoryMatch>, List<MemoryMatch>, Collection<MemoryMatch>> function;

    private Combiner(String name, BiFunction<List<MemoryMatch>, List<MemoryMatch>, Collection<MemoryMatch>> function) {
        this.name = name;
        this.function = function;
    }

    public boolean isMerge() {
        return this != REPLACE;
    }

    public String getName() {
        return this.name;
    }

    public Collection<MemoryMatch> combine(List<MemoryMatch> matches1, List<MemoryMatch> matches2) {
        return this.function.apply(matches1, matches2);
    }

    private static Collection<MemoryMatch> replace(List<MemoryMatch> matches1, List<MemoryMatch> matches2) {
        return matches2;
    }

    private static Collection<MemoryMatch> union(List<MemoryMatch> matches1, List<MemoryMatch> matches2) {
        Map<Address, MemoryMatch> matches1Map = Combiner.createMap(matches1);
        for (MemoryMatch match2 : matches2) {
            Address address = match2.getAddress();
            MemoryMatch match1 = matches1Map.get(address);
            if (match1 != null && match2.getLength() <= match1.getLength()) continue;
            matches1Map.put(address, match2);
        }
        return matches1Map.values();
    }

    private static Collection<MemoryMatch> intersect(List<MemoryMatch> matches1, List<MemoryMatch> matches2) {
        ArrayList<MemoryMatch> intersection = new ArrayList<MemoryMatch>();
        Map<Address, MemoryMatch> matches1Map = Combiner.createMap(matches1);
        for (MemoryMatch match2 : matches2) {
            Address address = match2.getAddress();
            MemoryMatch match1 = matches1Map.get(address);
            if (match1 == null) continue;
            MemoryMatch best = match2.getLength() > match1.getLength() ? match2 : match1;
            intersection.add(best);
        }
        return intersection;
    }

    private static List<MemoryMatch> xor(List<MemoryMatch> matches1, List<MemoryMatch> matches2) {
        ArrayList<MemoryMatch> results = new ArrayList<MemoryMatch>();
        results.addAll(Combiner.subtract(matches1, matches2));
        results.addAll(Combiner.subtract(matches2, matches1));
        return results;
    }

    private static Collection<MemoryMatch> subtract(List<MemoryMatch> matches1, List<MemoryMatch> matches2) {
        Map<Address, MemoryMatch> matches1Map = Combiner.createMap(matches1);
        for (MemoryMatch match2 : matches2) {
            Address address = match2.getAddress();
            matches1Map.remove(address);
        }
        return matches1Map.values();
    }

    private static Collection<MemoryMatch> reverseSubtract(List<MemoryMatch> matches1, List<MemoryMatch> matches2) {
        return Combiner.subtract(matches2, matches1);
    }

    private static Map<Address, MemoryMatch> createMap(List<MemoryMatch> matches) {
        HashMap<Address, MemoryMatch> map = new HashMap<Address, MemoryMatch>();
        for (MemoryMatch result : matches) {
            map.put(result.getAddress(), result);
        }
        return map;
    }
}

