/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.nav.Navigatable;
import ghidra.app.util.XReferenceUtils;
import ghidra.app.util.query.TableService;
import ghidra.app.util.viewer.field.XRefFieldMouseHandler;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.program.util.VariableXRefFieldLocation;
import ghidra.program.util.VariableXRefHeaderFieldLocation;
import java.util.HashSet;
import java.util.Set;

public class VariableXRefFieldMouseHandler
extends XRefFieldMouseHandler {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{VariableXRefFieldLocation.class, VariableXRefHeaderFieldLocation.class};

    @Override
    protected Address getFromReferenceAddress(ProgramLocation programLocation) {
        return ((VariableXRefFieldLocation)programLocation).getRefAddress();
    }

    @Override
    public Class<?>[] getSupportedProgramLocations() {
        return SUPPORTED_CLASSES;
    }

    @Override
    protected boolean isXREFHeaderLocation(ProgramLocation location) {
        return location instanceof VariableXRefHeaderFieldLocation;
    }

    @Override
    protected void showXRefDialog(Navigatable navigatable, ProgramLocation location, ServiceProvider serviceProvider) {
        TableService service = (TableService)serviceProvider.getService(TableService.class);
        if (service == null) {
            return;
        }
        VariableLocation variableLocation = (VariableLocation)location;
        Variable variable = variableLocation.getVariable();
        Set<Reference> refs = this.getVariableRefs(variable);
        XReferenceUtils.showXrefs(navigatable, serviceProvider, service, location, refs);
    }

    private Set<Reference> getVariableRefs(Variable var) {
        Reference[] refs;
        HashSet<Reference> results = new HashSet<Reference>();
        Address addr = var.getMinAddress();
        if (addr == null) {
            return results;
        }
        Program program = var.getFunction().getProgram();
        ReferenceManager refMgr = program.getReferenceManager();
        for (Reference vref : refs = refMgr.getReferencesTo(var)) {
            results.add(vref);
        }
        return results;
    }
}

