/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51ExternalDef;
import ghidra.app.util.bin.format.omf.omf51.Omf51RecordTypes;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Omf51ExternalDefsRecord
extends OmfRecord {
    private boolean largeExtId;
    private List<Omf51ExternalDef> defs = new ArrayList<Omf51ExternalDef>();

    public Omf51ExternalDefsRecord(BinaryReader reader, boolean largeExtId) throws IOException {
        super(reader);
        this.largeExtId = largeExtId;
    }

    @Override
    public void parseData() throws IOException, OmfException {
        while (this.dataReader.getPointerIndex() < this.dataEnd) {
            this.defs.add(new Omf51ExternalDef(this.dataReader, this.largeExtId));
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(Omf51RecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", null);
        for (Omf51ExternalDef def : this.defs) {
            struct.add(BYTE, "blockType", null);
            struct.add(this.largeExtId ? WORD : BYTE, "extId", null);
            struct.add(BYTE, "info", null);
            struct.add(BYTE, "unused", null);
            struct.add(def.getName().toDataType(), def.getName().getDataTypeSize(), "name", null);
        }
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }

    public List<Omf51ExternalDef> getDefinitions() {
        return this.defs;
    }
}

