/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.dyld;

import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.DynamicLibrary;
import ghidra.app.util.bin.format.macho.commands.DynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.DataConverter;
import ghidra.util.SystemUtilities;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public abstract class AbstractClassicProcessor {
    protected MachHeader header;
    protected Program program;

    protected AbstractClassicProcessor(MachHeader header, Program program) {
        this.header = header;
        this.program = program;
    }

    public final void perform(String segmentName, String sectionName, long addressValue, String fromDylib, NList nList, boolean isWeak, TaskMonitor monitor) throws Exception {
        Relocation.Status status;
        monitor.setMessage("Performing bind: " + nList.getString());
        Language language = this.program.getLanguage();
        Memory memory = this.program.getMemory();
        Listing listing = this.program.getListing();
        AddressFactory addressFactory = this.program.getAddressFactory();
        AddressSpace defaultAddressSpace = addressFactory.getDefaultAddressSpace();
        Address address = defaultAddressSpace.getAddress(addressValue);
        DataConverter converter = DataConverter.getInstance((boolean)language.isBigEndian());
        Symbol symbol = this.getSymbol(nList);
        if (symbol == null) {
            return;
        }
        listing.setComment(symbol.getAddress(), CommentType.PLATE, fromDylib);
        long offset = symbol.getAddress().getOffset();
        int fileType = this.header.getFileType();
        int byteLength = 0;
        switch (fileType) {
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                byte[] bytes = this.program.getDefaultPointerSize() == 8 ? converter.getBytes(offset) : converter.getBytes((int)offset);
                memory.setBytes(address, bytes);
                byteLength = bytes.length;
                break;
            }
            case 11: {
                if (this.header.getCpuType() == 7 || this.header.getCpuType() == 0x1000007) {
                    MemoryBlock block = memory.getBlock(address);
                    if (block.isExecute()) {
                        byte instructionByte = memory.getByte(address.subtract(1L));
                        if (instructionByte != -24 && instructionByte != -23) break;
                        long difference = offset - addressValue - 4L;
                        byte[] bytes = converter.getBytes((int)difference);
                        memory.setBytes(address, bytes);
                        byteLength = bytes.length;
                        break;
                    }
                    byte[] bytes = this.program.getDefaultPointerSize() == 8 ? converter.getBytes(offset) : converter.getBytes((int)offset);
                    memory.setBytes(address, bytes);
                    byteLength = bytes.length;
                    break;
                }
                if (this.header.getCpuType() == 18) {
                    if (!SystemUtilities.isInDevelopmentMode()) break;
                    System.out.println("CPU_TYPE_POWERPC");
                    break;
                }
                if (this.header.getCpuType() != 12 || !SystemUtilities.isInDevelopmentMode()) break;
                System.out.println("CPU_TYPE_ARM ");
                break;
            }
            case 1: {
                byte[] bytes = this.program.getDefaultPointerSize() == 8 ? converter.getBytes(offset) : converter.getBytes((int)offset);
                memory.setBytes(address, bytes);
                byteLength = bytes.length;
                break;
            }
        }
        if (byteLength <= 0) {
            this.program.getBookmarkManager().setBookmark(address, "Error", "Unhandled Classic Binding", "Unable to fixup classic binding. This instruction will contain an invalid destination / fixup.");
            status = Relocation.Status.UNSUPPORTED;
        } else {
            status = Relocation.Status.APPLIED;
        }
        String symbolName = symbol.getName();
        this.program.getRelocationTable().add(address, status, fileType, null, byteLength, symbolName);
    }

    protected Symbol getSymbol(NList nList) {
        SymbolTable symbolTable = this.program.getSymbolTable();
        SymbolIterator symbolIterator = symbolTable.getSymbols(nList.getString());
        if (symbolIterator.hasNext()) {
            return symbolIterator.next();
        }
        return null;
    }

    protected Section getSectionName(long address) {
        List<Section> sections = this.header.getAllSections();
        for (Section section : sections) {
            if (section.getAddress() > address || address >= section.getAddress() + section.getSize()) continue;
            return section;
        }
        return null;
    }

    protected String getClassicOrdinalName(int libraryOrdinal) {
        switch (libraryOrdinal) {
            case 0: {
                return "this-image";
            }
            case -1: {
                return "main-executable";
            }
            case -2: {
                return "flat-namespace";
            }
        }
        List<DynamicLibraryCommand> dylibCommands = this.header.getLoadCommands(DynamicLibraryCommand.class);
        if (libraryOrdinal >= dylibCommands.size()) {
            return "dyld info library ordinal out of range" + Integer.toHexString(libraryOrdinal);
        }
        DynamicLibraryCommand dylibCommand = dylibCommands.get(libraryOrdinal);
        DynamicLibrary dynamicLibrary = dylibCommand.getDynamicLibrary();
        LoadCommandString name = dynamicLibrary.getName();
        return name.getString();
    }

    protected long getRelocationBase() {
        List<SegmentCommand> segments = this.header.getLoadCommands(SegmentCommand.class);
        if (this.program.getDefaultPointerSize() == 8 && (this.header.getFlags() & 0x20) != 0) {
            for (SegmentCommand segment : segments) {
                if (!segment.isWrite()) continue;
                return segment.getVMaddress();
            }
        }
        SegmentCommand firstSegment = segments.get(0);
        return firstSegment.getVMaddress();
    }
}

