/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFRange;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionEvaluator;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionResult;
import java.util.Arrays;

public class DWARFLocation {
    private DWARFRange addressRange;
    private byte[] expr;

    public DWARFLocation(long start, long end, byte[] expr) {
        this(new DWARFRange(start, end), expr);
    }

    public DWARFLocation(DWARFRange addressRange, byte[] expr) {
        this.addressRange = addressRange;
        this.expr = expr;
    }

    public DWARFRange getRange() {
        return this.addressRange;
    }

    public byte[] getExpr() {
        return this.expr;
    }

    public boolean isWildcard() {
        return this.addressRange == null;
    }

    public long getOffset(long pc) {
        return this.addressRange != null ? this.addressRange.getFrom() - pc : 0L;
    }

    public boolean contains(long addr) {
        return this.isWildcard() || this.addressRange.contains(addr);
    }

    public DWARFExpressionResult evaluate(DWARFCompilationUnit cu) throws DWARFExpressionException {
        DWARFExpressionEvaluator evaluator = new DWARFExpressionEvaluator(cu);
        return evaluator.evaluate(evaluator.readExpr(this.expr));
    }

    public String toString() {
        return "DWARFLocation: range: %s, expr: %s".formatted(this.addressRange, Arrays.toString(this.expr));
    }
}

