/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug.propertymanager;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.PropertyMap;
import ghidra.program.model.util.PropertyMapManager;

class PropertyDeleteCmd
implements Command<Program> {
    private String propName;
    private AddressSetView restrictedView;
    private String cmdName;

    public PropertyDeleteCmd(String propName, AddressSetView restrictedView) {
        this.propName = propName;
        this.restrictedView = restrictedView;
        this.cmdName = "Delete " + propName + " Properties";
    }

    public String getName() {
        return this.cmdName;
    }

    public boolean applyTo(Program program) {
        PropertyMapManager propMgr = program.getUsrPropertyManager();
        if (this.restrictedView != null && !this.restrictedView.isEmpty()) {
            PropertyMap map = propMgr.getPropertyMap(this.propName);
            AddressRangeIterator ranges = this.restrictedView.getAddressRanges();
            while (ranges.hasNext()) {
                AddressRange range = (AddressRange)ranges.next();
                map.removeRange(range.getMinAddress(), range.getMaxAddress());
            }
        } else {
            propMgr.removePropertyMap(this.propName);
        }
        return true;
    }

    public String getStatusMsg() {
        return null;
    }
}

