/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.sourcefilestable;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModelStub;
import ghidra.app.plugin.core.sourcefilestable.SourceFileRowObject;
import ghidra.app.plugin.core.sourcefilestable.SourceFilesTablePlugin;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.database.sourcemap.SourceFileIdType;
import ghidra.program.database.sourcemap.UserDataPathTransformer;
import ghidra.program.model.listing.Program;
import ghidra.program.model.sourcemap.SourceFileManager;
import ghidra.program.model.sourcemap.SourcePathTransformer;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class SourceFilesTableModel
extends ThreadedTableModelStub<SourceFileRowObject> {
    private Program program;
    private SourceFileManager sourceManager;
    private SourcePathTransformer pathTransformer;
    private boolean useExistingAsDefault;

    protected SourceFilesTableModel(SourceFilesTablePlugin sourceFilesTablePlugin) {
        super("Source File Table Model", (ServiceProvider)sourceFilesTablePlugin.getTool());
        this.program = sourceFilesTablePlugin.getCurrentProgram();
        if (this.program != null) {
            this.sourceManager = this.program.getSourceFileManager();
        }
    }

    protected TableColumnDescriptor<SourceFileRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new FileNameColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new PathColumn(this));
        descriptor.addHiddenColumn((DynamicTableColumn)new IdTypeColumn(this));
        descriptor.addHiddenColumn((DynamicTableColumn)new IdentifierColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new TransformedPathColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new NumMappedEntriesColumn(this));
        return descriptor;
    }

    protected void doLoad(Accumulator<SourceFileRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.sourceManager == null) {
            return;
        }
        for (SourceFile sourceFile : this.sourceManager.getAllSourceFiles()) {
            accumulator.add((Object)new SourceFileRowObject(sourceFile, this.sourceManager));
        }
    }

    protected void reloadProgram(Program newProgram) {
        this.program = newProgram;
        this.sourceManager = this.program == null ? null : this.program.getSourceFileManager();
        this.pathTransformer = this.program == null ? null : UserDataPathTransformer.getPathTransformer((Program)this.program);
        this.reload();
    }

    protected Program getProgram() {
        return this.program;
    }

    private class FileNameColumn
    extends AbstractDynamicTableColumn<SourceFileRowObject, String, Object> {
        private FileNameColumn(SourceFilesTableModel sourceFilesTableModel) {
        }

        public String getColumnName() {
            return "File Name";
        }

        public String getValue(SourceFileRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getFileName();
        }
    }

    private class PathColumn
    extends AbstractDynamicTableColumn<SourceFileRowObject, String, Object> {
        private PathColumn(SourceFilesTableModel sourceFilesTableModel) {
        }

        public String getColumnName() {
            return "Path";
        }

        public String getValue(SourceFileRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getPath();
        }
    }

    private class IdTypeColumn
    extends AbstractDynamicTableColumn<SourceFileRowObject, SourceFileIdType, Object> {
        private IdTypeColumn(SourceFilesTableModel sourceFilesTableModel) {
        }

        public String getColumnName() {
            return "ID Type";
        }

        public SourceFileIdType getValue(SourceFileRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getSourceFileIdType();
        }
    }

    private class IdentifierColumn
    extends AbstractDynamicTableColumn<SourceFileRowObject, String, Object> {
        private IdentifierColumn(SourceFilesTableModel sourceFilesTableModel) {
        }

        public String getColumnName() {
            return "Identifier";
        }

        public String getValue(SourceFileRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getSourceFile().getIdAsString();
        }
    }

    private class TransformedPathColumn
    extends AbstractDynamicTableColumn<SourceFileRowObject, String, Object> {
        private TransformedPathColumn() {
        }

        public String getColumnName() {
            return "Transformed Path";
        }

        public String getValue(SourceFileRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            if (SourceFilesTableModel.this.program == null) {
                return null;
            }
            if (SourceFilesTableModel.this.pathTransformer == null) {
                SourceFilesTableModel.this.pathTransformer = UserDataPathTransformer.getPathTransformer((Program)SourceFilesTableModel.this.program);
            }
            return SourceFilesTableModel.this.pathTransformer.getTransformedPath(rowObject.getSourceFile(), SourceFilesTableModel.this.useExistingAsDefault);
        }
    }

    private class NumMappedEntriesColumn
    extends AbstractDynamicTableColumn<SourceFileRowObject, Integer, Object> {
        private NumMappedEntriesColumn(SourceFilesTableModel sourceFilesTableModel) {
        }

        public String getColumnName() {
            return "Entry Count";
        }

        public Integer getValue(SourceFileRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getNumSourceMapEntries();
        }
    }
}

