/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.references.ReferencesPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableOffset;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.util.List;

public class CreateDefaultReferenceAction
extends ListingContextAction {
    static String DEFAULT_MENU_ITEM_NAME = "Create Default Reference";
    static String MEMORY_MENU_ITEM_NAME = "Create Memory Reference";
    static String STACK_MENU_ITEM_NAME = "Create Stack Reference";
    static String REGISTER_MENU_ITEM_NAME = "Create Register Reference";
    static final int UNKNOWN_REF_CLASS = -1;
    static final int MEMORY_REF_CLASS = 0;
    static final int STACK_REF_CLASS = 1;
    static final int REGISTER_REF_CLASS = 2;
    private ReferencesPlugin plugin;
    private ListingActionContext context;
    private int refClass = -1;
    private Register reg;
    private Address memAddr;
    private int stackOffset;

    public CreateDefaultReferenceAction(ReferencesPlugin plugin) {
        super("Create Default Reference", plugin.getName());
        this.plugin = plugin;
    }

    @Override
    protected void actionPerformed(ListingActionContext context) {
        if (this.context != context && !this.isEnabledForContext(context)) {
            return;
        }
        OperandFieldLocation opLoc = (OperandFieldLocation)context.getLocation();
        switch (this.refClass) {
            case 0: {
                CodeUnit cu = opLoc.getProgram().getListing().getCodeUnitContaining(opLoc.getAddress());
                RefType refType = cu instanceof Instruction ? null : RefType.DATA;
                this.plugin.addDefaultReference(context.getProgram(), opLoc.getAddress(), opLoc.getOperandIndex(), this.memAddr, refType);
                break;
            }
            case 1: {
                this.plugin.addDefaultReference(context.getProgram(), opLoc.getAddress(), opLoc.getOperandIndex(), this.stackOffset);
                break;
            }
            case 2: {
                this.plugin.addDefaultReference(context.getProgram(), opLoc.getAddress(), opLoc.getOperandIndex(), this.reg);
            }
        }
    }

    private void invalidateContext() {
        this.context = null;
        this.refClass = -1;
        this.memAddr = null;
        this.reg = null;
    }

    @Override
    protected boolean isAddToPopup(ListingActionContext context) {
        ProgramLocation loc = context.getLocation();
        return loc instanceof OperandFieldLocation;
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        this.invalidateContext();
        boolean actionOK = false;
        ProgramLocation loc = context.getLocation();
        if (loc instanceof OperandFieldLocation) {
            OperandFieldLocation opLoc = (OperandFieldLocation)context.getLocation();
            this.context = context;
            Program program = context.getProgram();
            opLoc = (OperandFieldLocation)loc;
            Address addr = opLoc.getAddress();
            int opIndex = opLoc.getOperandIndex();
            CodeUnit cu = program.getListing().getCodeUnitContaining(addr);
            if (cu != null) {
                Reference[] refs;
                if (cu instanceof Data) {
                    Data data = ((Data)cu).getComponent(opLoc.getComponentPath());
                    Object obj = data.getValue();
                    if (obj instanceof Scalar) {
                        this.refClass = 0;
                        actionOK = this.initMemoryAddress(program.getAddressFactory(), ((Scalar)obj).getUnsignedValue());
                    } else if (obj instanceof Address) {
                        this.memAddr = (Address)obj;
                        this.refClass = 0;
                        actionOK = true;
                    }
                } else {
                    Instruction instr = (Instruction)cu;
                    int subOpIndex = opLoc.getSubOperandIndex();
                    List opList = instr.getDefaultOperandRepresentationList(opIndex);
                    if (opList == null || subOpIndex < 0 || opList.size() <= subOpIndex) {
                        return false;
                    }
                    Object opObj = opList.get(subOpIndex);
                    if (opObj instanceof Address) {
                        Address opAddr = (Address)opObj;
                        if (opAddr.isMemoryAddress()) {
                            this.memAddr = opAddr;
                            this.refClass = 0;
                            actionOK = true;
                        }
                    } else {
                        Function f = program.getFunctionManager().getFunctionContaining(addr);
                        if (f != null) {
                            if (opObj instanceof Scalar) {
                                CallDepthChangeInfo cdInfo = new CallDepthChangeInfo(f);
                                this.stackOffset = cdInfo.getStackOffset(instr, opIndex);
                                if (this.stackOffset != 0x7FFFFFFE) {
                                    this.refClass = 1;
                                    Object[] opObjs = instr.getOpObjects(opIndex);
                                    for (int i = 0; !actionOK && i < opObjs.length; ++i) {
                                        if (!(opObjs[i] instanceof Register)) continue;
                                        int regDepth = cdInfo.getRegDepth(addr, (Register)opObjs[i]);
                                        actionOK = regDepth != 0x7FFFFFFE && regDepth != Integer.MAX_VALUE;
                                    }
                                }
                            } else if (opObj instanceof VariableOffset) {
                                VariableOffset varOff = (VariableOffset)opObj;
                                Object replacedObj = varOff.getReplacedElement();
                                if (replacedObj instanceof Register && RefTypeFactory.getDefaultRegisterRefType((CodeUnit)instr, (Register)((Register)replacedObj), (int)opIndex).isWrite()) {
                                    this.refClass = 2;
                                    this.reg = (Register)replacedObj;
                                    actionOK = true;
                                }
                            } else if (opObj instanceof Register) {
                                this.refClass = 2;
                                this.reg = (Register)opObj;
                                actionOK = true;
                            }
                        }
                        if (this.refClass == -1 && opObj instanceof Scalar) {
                            this.refClass = 0;
                            actionOK = this.initMemoryAddress(program.getAddressFactory(), ((Scalar)opObj).getUnsignedValue());
                        }
                    }
                }
                if (actionOK && (refs = program.getReferenceManager().getReferencesFrom(addr, opIndex)).length != 0) {
                    Address toAddr = refs[0].getToAddress();
                    if (toAddr.isExternalAddress()) {
                        actionOK = false;
                    } else {
                        block0 : switch (this.refClass) {
                            case 0: {
                                if (this.memAddr == null || !toAddr.isMemoryAddress()) break;
                                for (int i = 0; i < refs.length; ++i) {
                                    if (refs[i].getSource() == SourceType.DEFAULT || !this.memAddr.equals((Object)toAddr)) continue;
                                    actionOK = false;
                                    break block0;
                                }
                                break;
                            }
                            case 1: {
                                if (!refs[0].isStackReference()) break;
                                actionOK = false;
                                break;
                            }
                            case 2: {
                                if (!refs[0].getToAddress().isRegisterAddress()) break;
                                actionOK = false;
                            }
                        }
                    }
                }
            }
        }
        this.updatePopupMenuPath(actionOK);
        return actionOK;
    }

    private Address buildDestinationAddress(AddressSpace addrSpace, Address sourceAddress, long offset) {
        try {
            if (addrSpace instanceof SegmentedAddressSpace) {
                SegmentedAddressSpace segmentedSpace = (SegmentedAddressSpace)addrSpace;
                if (sourceAddress instanceof SegmentedAddress) {
                    SegmentedAddress segmentedAddr = (SegmentedAddress)sourceAddress;
                    return segmentedSpace.getAddress(segmentedAddr.getSegment(), (int)(offset & 0xFFFFL));
                }
            }
            return addrSpace.getAddress(offset, true);
        }
        catch (AddressOutOfBoundsException e) {
            return null;
        }
    }

    private boolean initMemoryAddress(AddressFactory addrFactory, long offset) {
        AddressSpace contextAddrSpace = this.context.getAddress().getAddressSpace();
        Address address = this.buildDestinationAddress(contextAddrSpace, this.context.getAddress(), offset);
        if (address != null) {
            this.memAddr = address;
            return true;
        }
        AddressSpace defaultSpace = addrFactory.getDefaultAddressSpace();
        if (contextAddrSpace != defaultSpace) {
            address = this.buildDestinationAddress(defaultSpace, this.context.getAddress(), offset);
        }
        if (address != null) {
            this.memAddr = address;
            return true;
        }
        return false;
    }

    private void updatePopupMenuPath(boolean actionOK) {
        if (actionOK) {
            switch (this.refClass) {
                case 0: {
                    this.getPopupMenuData().setMenuItemName(MEMORY_MENU_ITEM_NAME);
                    break;
                }
                case 1: {
                    this.getPopupMenuData().setMenuItemName(STACK_MENU_ITEM_NAME);
                    break;
                }
                case 2: {
                    this.getPopupMenuData().setMenuItemName(REGISTER_MENU_ITEM_NAME);
                    break;
                }
                default: {
                    this.getPopupMenuData().setMenuItemName(DEFAULT_MENU_ITEM_NAME);
                    break;
                }
            }
        } else {
            this.getPopupMenuData().setMenuItemName(DEFAULT_MENU_ITEM_NAME);
        }
    }

    int getDefaultRefClass() {
        return this.refClass;
    }
}

