/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.graph;

import docking.widgets.EventTrigger;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.nav.NavigationUtils;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.DomainObjectListenerBuilder;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginEventListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.util.Swing;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AddressBasedGraphDisplayListener
implements GraphDisplayListener,
PluginEventListener {
    protected PluginTool tool;
    protected GraphDisplay graphDisplay;
    protected Program program;
    private SymbolTable symbolTable;
    private String name;
    private DomainObjectListener domainObjectListener;
    private static AtomicInteger instanceCount = new AtomicInteger(1);

    public AddressBasedGraphDisplayListener(PluginTool tool, Program program, GraphDisplay display) {
        this.tool = tool;
        this.program = program;
        this.symbolTable = program.getSymbolTable();
        this.graphDisplay = display;
        this.name = this.getClass().getSimpleName() + instanceCount.getAndAdd(1);
        tool.addListenerForAllPluginEvents((PluginEventListener)this);
        this.domainObjectListener = this.createDomainObjectListener();
        program.addListener(this.domainObjectListener);
    }

    private DomainObjectListener createDomainObjectListener() {
        return new DomainObjectListenerBuilder((Object)this).with(ProgramChangeRecord.class).each(new EventType[]{ProgramEvent.SYMBOL_ADDED}).call(this::handleSymbolAdded).each(new EventType[]{ProgramEvent.SYMBOL_RENAMED}).call(this::handleSymbolRenamed).each(new EventType[]{ProgramEvent.SYMBOL_REMOVED}).call(this::handleSymbolRemoved).build();
    }

    private void handleSymbolAdded(ProgramChangeRecord rec) {
        Symbol symbol = (Symbol)rec.getNewValue();
        AttributedVertex vertex = this.getVertex(rec.getStart());
        if (vertex != null) {
            this.graphDisplay.updateVertexName(vertex, symbol.getName());
        }
    }

    private void handleSymbolRenamed(ProgramChangeRecord rec) {
        Symbol symbol = (Symbol)rec.getObject();
        AttributedVertex vertex = this.getVertex(rec.getStart());
        if (vertex != null) {
            this.graphDisplay.updateVertexName(vertex, symbol.getName());
        }
    }

    private void handleSymbolRemoved(ProgramChangeRecord rec) {
        Address address = rec.getStart();
        AttributedVertex vertex = this.getVertex(address);
        if (vertex == null) {
            return;
        }
        Symbol symbol = this.program.getSymbolTable().getPrimarySymbol(address);
        String displayName = symbol == null ? address.toString() : symbol.getName();
        this.graphDisplay.updateVertexName(vertex, displayName);
    }

    public void locationFocusChanged(AttributedVertex vertex) {
        Address address = this.getAddress(vertex);
        if (address != null) {
            ProgramLocation location = new ProgramLocation(this.program, address);
            this.tool.firePluginEvent((PluginEvent)new ProgramLocationPluginEvent(this.name, location, this.program));
        }
    }

    public void selectionChanged(Set<AttributedVertex> vertices) {
        AddressSet addressSet = this.getAddresses(vertices);
        if (addressSet != null) {
            ProgramSelection selection = new ProgramSelection((AddressSetView)addressSet);
            ProgramSelectionPluginEvent event = new ProgramSelectionPluginEvent(this.name, selection, this.program);
            this.tool.firePluginEvent((PluginEvent)event);
        }
    }

    public void eventSent(PluginEvent event) {
        ProgramSelection selection;
        Set<AttributedVertex> selectedVertices;
        ProgramSelectionPluginEvent ev;
        if (Objects.equals(event.getSourceName(), this.name)) {
            return;
        }
        if (event instanceof ProgramClosedPluginEvent) {
            ProgramClosedPluginEvent ev2 = (ProgramClosedPluginEvent)event;
            if (this.isMyProgram(ev2.getProgram())) {
                this.graphDisplay.close();
                this.dispose();
            }
        } else if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent ev3 = (ProgramLocationPluginEvent)event;
            if (this.isMyProgram(ev3.getProgram())) {
                ProgramLocation location = ev3.getLocation();
                AttributedVertex vertex = this.getVertex(location.getAddress());
                this.graphDisplay.setFocusedVertex(vertex, EventTrigger.INTERNAL_ONLY);
            }
        } else if (event instanceof ProgramSelectionPluginEvent && this.isMyProgram((ev = (ProgramSelectionPluginEvent)event).getProgram()) && (selectedVertices = this.getVertices(selection = ev.getSelection())) != null) {
            this.graphDisplay.selectVertices(selectedVertices, EventTrigger.INTERNAL_ONLY);
        }
    }

    public AttributedVertex getVertex(Address address) {
        if (address == null) {
            return null;
        }
        String id = this.getVertexId(address);
        if (id == null) {
            return null;
        }
        return this.graphDisplay.getGraph().getVertex(id);
    }

    protected String getVertexId(Address address) {
        if (address.isExternalAddress()) {
            Symbol s = this.symbolTable.getPrimarySymbol(address);
            return s.getName(true);
        }
        return address.toString();
    }

    protected Address getAddress(String vertexIdString) {
        Address[] externalLinkageAddresses;
        Address address = this.program.getAddressFactory().getAddress(vertexIdString);
        if (address != null) {
            return address;
        }
        int index = vertexIdString.indexOf("::");
        if (index <= 0) {
            return null;
        }
        String namespaceName = vertexIdString.substring(0, index);
        String symbolName = vertexIdString.substring(index + 2);
        Namespace namespace = this.symbolTable.getNamespace(namespaceName, null);
        if (namespace == null) {
            return null;
        }
        List symbols = this.symbolTable.getSymbols(symbolName, namespace);
        if (symbols.isEmpty()) {
            return null;
        }
        Address symbolAddress = ((Symbol)symbols.get(0)).getAddress();
        if (symbolAddress.isExternalAddress() && (externalLinkageAddresses = NavigationUtils.getExternalLinkageAddresses(this.program, symbolAddress)).length == 1) {
            symbolAddress = externalLinkageAddresses[0];
        }
        return symbolAddress;
    }

    protected Address getAddress(AttributedVertex vertex) {
        if (vertex == null) {
            return null;
        }
        return this.getAddress(vertex.getId());
    }

    protected abstract Set<AttributedVertex> getVertices(AddressSetView var1);

    protected abstract AddressSet getAddresses(Set<AttributedVertex> var1);

    private boolean isMyProgram(Program p) {
        return p == this.program;
    }

    public void dispose() {
        Swing.runLater(() -> this.tool.removeListenerForAllPluginEvents((PluginEventListener)this));
        this.program.removeListener(this.domainObjectListener);
    }
}

