/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.util.HelpLocation;
import javax.swing.tree.TreePath;

public class EditAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public EditAction(DataTypeManagerPlugin plugin) {
        super("Edit", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Edit"}, null, "Edit"));
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Edit_Data_Type"));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return false;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return false;
        }
        DataTypeNode dataTypeNode = (DataTypeNode)node;
        return dataTypeNode.hasCustomEditor();
    }

    public void actionPerformed(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        DataTypeNode node = (DataTypeNode)((Object)selectionPaths[0].getLastPathComponent());
        this.plugin.getProvider().editNode((GTreeNode)node);
    }
}

