/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.database.DBStringMapAdapter;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BitFieldPacking;
import ghidra.program.model.data.BitFieldPackingImpl;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.Language;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class DataOrganizationImpl
implements DataOrganization {
    public static final int DEFAULT_MACHINE_ALIGNMENT = 8;
    public static final int DEFAULT_DEFAULT_ALIGNMENT = 1;
    public static final int DEFAULT_DEFAULT_POINTER_ALIGNMENT = 4;
    public static final int DEFAULT_POINTER_SHIFT = 0;
    public static final int DEFAULT_POINTER_SIZE = 4;
    public static final int DEFAULT_CHAR_SIZE = 1;
    public static final boolean DEFAULT_CHAR_IS_SIGNED = true;
    public static final int DEFAULT_WIDE_CHAR_SIZE = 2;
    public static final int DEFAULT_SHORT_SIZE = 2;
    public static final int DEFAULT_INT_SIZE = 4;
    public static final int DEFAULT_LONG_SIZE = 4;
    public static final int DEFAULT_LONG_LONG_SIZE = 8;
    public static final int DEFAULT_FLOAT_SIZE = 4;
    public static final int DEFAULT_DOUBLE_SIZE = 8;
    public static final int DEFAULT_LONG_DOUBLE_SIZE = 8;
    private static final String BIG_ENDIAN_NAME = "big_endian";
    private static final String SIGNED_CHAR_TYPE_NAME = "signed_char_type";
    private int absoluteMaxAlignment = 0;
    private int machineAlignment = 8;
    private int defaultAlignment = 1;
    private int defaultPointerAlignment = 4;
    private int pointerShift = 0;
    private int pointerSize = 4;
    private int charSize = 1;
    private boolean isSignedChar = true;
    private int wideCharSize = 2;
    private int shortSize = 2;
    private int integerSize = 4;
    private int longSize = 4;
    private int longLongSize = 8;
    private int floatSize = 4;
    private int doubleSize = 8;
    private int longDoubleSize = 8;
    private boolean bigEndian = false;
    private BitFieldPackingImpl bitFieldPacking = new BitFieldPackingImpl();
    private final TreeMap<Integer, Integer> sizeAlignmentMap = new TreeMap();

    public static DataOrganization getDefaultOrganization() {
        return DataOrganizationImpl.getDefaultOrganization(null);
    }

    public static DataOrganizationImpl getDefaultOrganization(Language language) {
        DataOrganizationImpl dataOrganization = new DataOrganizationImpl();
        dataOrganization.setSizeAlignment(1, 1);
        dataOrganization.setSizeAlignment(2, 2);
        dataOrganization.setSizeAlignment(4, 4);
        dataOrganization.setSizeAlignment(8, 8);
        if (language != null) {
            dataOrganization.setPointerSize(language.getDefaultSpace().getPointerSize());
            dataOrganization.setBigEndian(language.isBigEndian());
        }
        return dataOrganization;
    }

    private DataOrganizationImpl() {
    }

    @Override
    public boolean isBigEndian() {
        return this.bigEndian;
    }

    @Override
    public int getPointerSize() {
        return this.pointerSize;
    }

    @Override
    public int getPointerShift() {
        return this.pointerShift;
    }

    @Override
    public boolean isSignedChar() {
        return this.isSignedChar;
    }

    @Override
    public int getCharSize() {
        return this.charSize;
    }

    @Override
    public int getWideCharSize() {
        return this.wideCharSize;
    }

    @Override
    public int getShortSize() {
        return this.shortSize;
    }

    @Override
    public int getIntegerSize() {
        return this.integerSize;
    }

    @Override
    public int getLongSize() {
        return this.longSize;
    }

    @Override
    public int getLongLongSize() {
        return this.longLongSize;
    }

    @Override
    public int getFloatSize() {
        return this.floatSize;
    }

    @Override
    public int getDoubleSize() {
        return this.doubleSize;
    }

    @Override
    public int getLongDoubleSize() {
        return this.longDoubleSize;
    }

    @Override
    public BitFieldPacking getBitFieldPacking() {
        return this.bitFieldPacking;
    }

    public void setBigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public void setPointerSize(int pointerSize) {
        this.pointerSize = pointerSize;
    }

    public void setPointerShift(int pointerShift) {
        this.pointerShift = pointerShift;
    }

    public void setCharIsSigned(boolean signed) {
        this.isSignedChar = signed;
    }

    public void setCharSize(int charSize) {
        this.charSize = charSize;
    }

    public void setWideCharSize(int wideCharSize) {
        this.wideCharSize = wideCharSize;
    }

    public void setShortSize(int shortSize) {
        this.shortSize = shortSize;
        if (this.integerSize < shortSize) {
            this.setIntegerSize(shortSize);
        }
    }

    public void setIntegerSize(int integerSize) {
        this.integerSize = integerSize;
        if (this.longSize < integerSize) {
            this.setLongSize(integerSize);
        }
        if (this.shortSize > integerSize) {
            this.setShortSize(integerSize);
        }
    }

    public void setLongSize(int longSize) {
        this.longSize = longSize;
        if (this.longLongSize < longSize) {
            this.setLongLongSize(longSize);
        }
        if (this.integerSize > longSize) {
            this.setIntegerSize(longSize);
        }
    }

    public void setLongLongSize(int longLongSize) {
        this.longLongSize = longLongSize;
        if (this.longSize > longLongSize) {
            this.setLongSize(longLongSize);
        }
    }

    public void setFloatSize(int floatSize) {
        this.floatSize = floatSize;
        if (this.doubleSize < floatSize) {
            this.setDoubleSize(floatSize);
        }
    }

    public void setDoubleSize(int doubleSize) {
        this.doubleSize = doubleSize;
        if (this.longDoubleSize < doubleSize) {
            this.setLongDoubleSize(doubleSize);
        }
        if (this.floatSize > doubleSize) {
            this.setFloatSize(doubleSize);
        }
    }

    public void setLongDoubleSize(int longDoubleSize) {
        this.longDoubleSize = longDoubleSize;
        if (this.doubleSize > longDoubleSize) {
            this.setDoubleSize(longDoubleSize);
        }
    }

    @Override
    public int getAbsoluteMaxAlignment() {
        return this.absoluteMaxAlignment;
    }

    @Override
    public int getMachineAlignment() {
        return this.machineAlignment;
    }

    @Override
    public int getDefaultAlignment() {
        return this.defaultAlignment;
    }

    @Override
    public int getDefaultPointerAlignment() {
        return this.defaultPointerAlignment;
    }

    public void setAbsoluteMaxAlignment(int absoluteMaxAlignment) {
        this.absoluteMaxAlignment = absoluteMaxAlignment;
    }

    public void setMachineAlignment(int machineAlignment) {
        this.machineAlignment = machineAlignment;
    }

    public void setDefaultAlignment(int defaultAlignment) {
        this.defaultAlignment = defaultAlignment;
    }

    public void setDefaultPointerAlignment(int defaultPointerAlignment) {
        this.defaultPointerAlignment = defaultPointerAlignment;
    }

    @Override
    public int getSizeAlignment(int size) {
        int alignment;
        Map.Entry<Integer, Integer> floorEntry = this.sizeAlignmentMap.floorEntry(size);
        int n = alignment = floorEntry != null ? floorEntry.getValue() : this.defaultAlignment;
        if (this.absoluteMaxAlignment != 0) {
            return Math.min(alignment, this.absoluteMaxAlignment);
        }
        return alignment;
    }

    public void setSizeAlignment(int size, int alignment) {
        this.sizeAlignmentMap.put(size, alignment);
    }

    public void setBitFieldPacking(BitFieldPackingImpl bitFieldPacking) {
        this.bitFieldPacking = bitFieldPacking;
    }

    public void clearSizeAlignmentMap() {
        this.sizeAlignmentMap.clear();
    }

    @Override
    public int getSizeAlignmentCount() {
        return this.sizeAlignmentMap.size();
    }

    @Override
    public int[] getSizes() {
        Set<Integer> keySet = this.sizeAlignmentMap.keySet();
        int[] keys = new int[keySet.size()];
        int index = 0;
        for (Integer k : keySet) {
            keys[index++] = k;
        }
        Arrays.sort(keys);
        return keys;
    }

    @Override
    public String getIntegerCTypeApproximation(int size, boolean signed) {
        Object ctype = "long long";
        if (size <= 1) {
            ctype = "char";
        } else if (size <= this.getShortSize() && this.getShortSize() != this.getIntegerSize()) {
            ctype = "short";
        } else if (size <= this.getIntegerSize()) {
            ctype = "int";
        } else if (size <= this.getLongSize()) {
            ctype = "long";
        }
        if (!signed) {
            ctype = "unsigned " + (String)ctype;
        }
        return ctype;
    }

    @Override
    public int getAlignment(DataType dataType) {
        int dtSize = dataType.getAlignedLength();
        if (dataType instanceof Dynamic || dataType instanceof FactoryDataType || dtSize <= 0) {
            return 1;
        }
        if (dataType instanceof TypeDef) {
            return this.getAlignment(((TypeDef)dataType).getBaseDataType());
        }
        if (dataType instanceof Array) {
            DataType elementDt = ((Array)dataType).getDataType();
            return this.getAlignment(elementDt);
        }
        if (dataType instanceof Composite) {
            return ((Composite)dataType).getAlignment();
        }
        if (dataType instanceof BitFieldDataType) {
            BitFieldDataType bitfieldDt = (BitFieldDataType)dataType;
            return this.getAlignment(bitfieldDt.getBaseDataType());
        }
        if (!this.sizeAlignmentMap.containsKey(dtSize) && dataType instanceof Pointer) {
            return this.getDefaultPointerAlignment();
        }
        return this.getSizeAlignment(dtSize);
    }

    public static int getAlignedOffset(int alignment, int minimumOffset) {
        if (alignment <= 0) {
            return minimumOffset;
        }
        if (DataOrganizationImpl.isPowerOfTwo(alignment)) {
            return alignment + (minimumOffset - 1 & ~(alignment - 1));
        }
        int offcut = minimumOffset % alignment;
        int adj = offcut != 0 ? alignment - offcut : 0;
        return minimumOffset + adj;
    }

    private static boolean isPowerOfTwo(int n) {
        return (n & n - 1) == 0;
    }

    public static int getLeastCommonMultiple(int value1, int value2) {
        int gcd = DataOrganizationImpl.getGreatestCommonDenominator(value1, value2);
        return gcd != 0 ? value1 / gcd * value2 : 0;
    }

    public static int getGreatestCommonDenominator(int value1, int value2) {
        return value2 != 0 ? DataOrganizationImpl.getGreatestCommonDenominator(value2, value1 % value2) : value1;
    }

    public static void save(DataOrganization dataOrg, DBStringMapAdapter dataMap, String keyPrefix) throws IOException {
        int longDoubleSize;
        int doubleSize;
        int floatSize;
        int longLongSize;
        int longSize;
        int integerSize;
        int shortSize;
        int wideCharSize;
        int charSize;
        boolean isSignedChar;
        int pointerShift;
        int pointerSize;
        int defaultPointerAlignment;
        int defaultAlignment;
        int machineAlignment;
        int absoluteMaxAlignment;
        for (String key : dataMap.keySet()) {
            if (!key.startsWith(keyPrefix)) continue;
            dataMap.delete(key);
        }
        if (dataOrg.isBigEndian()) {
            dataMap.put(keyPrefix + BIG_ENDIAN_NAME, Boolean.TRUE.toString());
        }
        if ((absoluteMaxAlignment = dataOrg.getAbsoluteMaxAlignment()) != 0) {
            dataMap.put(keyPrefix + ElementId.ELEM_ABSOLUTE_MAX_ALIGNMENT.name(), Integer.toString(absoluteMaxAlignment));
        }
        if ((machineAlignment = dataOrg.getMachineAlignment()) != 8) {
            dataMap.put(keyPrefix + ElementId.ELEM_MACHINE_ALIGNMENT.name(), Integer.toString(machineAlignment));
        }
        if ((defaultAlignment = dataOrg.getDefaultAlignment()) != 1) {
            dataMap.put(keyPrefix + ElementId.ELEM_DEFAULT_ALIGNMENT.name(), Integer.toString(defaultAlignment));
        }
        if ((defaultPointerAlignment = dataOrg.getDefaultPointerAlignment()) != 4) {
            dataMap.put(keyPrefix + ElementId.ELEM_DEFAULT_POINTER_ALIGNMENT.name(), Integer.toString(defaultPointerAlignment));
        }
        if ((pointerSize = dataOrg.getPointerSize()) != 4) {
            dataMap.put(keyPrefix + ElementId.ELEM_POINTER_SIZE.name(), Integer.toString(pointerSize));
        }
        if ((pointerShift = dataOrg.getPointerShift()) != 0) {
            dataMap.put(keyPrefix + ElementId.ELEM_POINTER_SHIFT.name(), Integer.toString(pointerShift));
        }
        if (!(isSignedChar = dataOrg.isSignedChar())) {
            dataMap.put(keyPrefix + SIGNED_CHAR_TYPE_NAME, Boolean.toString(isSignedChar));
        }
        if ((charSize = dataOrg.getCharSize()) != 1) {
            dataMap.put(keyPrefix + ElementId.ELEM_CHAR_SIZE.name(), Integer.toString(charSize));
        }
        if ((wideCharSize = dataOrg.getWideCharSize()) != 2) {
            dataMap.put(keyPrefix + ElementId.ELEM_WCHAR_SIZE.name(), Integer.toString(wideCharSize));
        }
        if ((shortSize = dataOrg.getShortSize()) != 2) {
            dataMap.put(keyPrefix + ElementId.ELEM_SHORT_SIZE.name(), Integer.toString(shortSize));
        }
        if ((integerSize = dataOrg.getIntegerSize()) != 4) {
            dataMap.put(keyPrefix + ElementId.ELEM_INTEGER_SIZE.name(), Integer.toString(integerSize));
        }
        if ((longSize = dataOrg.getLongSize()) != 4) {
            dataMap.put(keyPrefix + ElementId.ELEM_LONG_SIZE.name(), Integer.toString(longSize));
        }
        if ((longLongSize = dataOrg.getLongLongSize()) != 8) {
            dataMap.put(keyPrefix + ElementId.ELEM_LONG_LONG_SIZE.name(), Integer.toString(longLongSize));
        }
        if ((floatSize = dataOrg.getFloatSize()) != 4) {
            dataMap.put(keyPrefix + ElementId.ELEM_FLOAT_SIZE.name(), Integer.toString(floatSize));
        }
        if ((doubleSize = dataOrg.getDoubleSize()) != 8) {
            dataMap.put(keyPrefix + ElementId.ELEM_DOUBLE_SIZE.name(), Integer.toString(doubleSize));
        }
        if ((longDoubleSize = dataOrg.getLongDoubleSize()) != 8) {
            dataMap.put(keyPrefix + ElementId.ELEM_LONG_DOUBLE_SIZE.name(), Integer.toString(longDoubleSize));
        }
        for (int size : dataOrg.getSizes()) {
            String key = keyPrefix + ElementId.ELEM_SIZE_ALIGNMENT_MAP.name() + "." + size;
            dataMap.put(key, Integer.toString(dataOrg.getSizeAlignment(size)));
        }
        BitFieldPackingImpl.save(dataOrg.getBitFieldPacking(), dataMap, keyPrefix + ElementId.ELEM_BITFIELD_PACKING.name() + ".");
    }

    public static DataOrganizationImpl restore(DBStringMapAdapter dataMap, String keyPrefix) throws IOException {
        boolean containsDataOrgEntries = false;
        for (String key : dataMap.keySet()) {
            if (!key.startsWith(keyPrefix)) continue;
            containsDataOrgEntries = true;
            break;
        }
        if (!containsDataOrgEntries) {
            return null;
        }
        DataOrganizationImpl dataOrg = new DataOrganizationImpl();
        dataOrg.bigEndian = dataMap.getBoolean(keyPrefix + BIG_ENDIAN_NAME, false);
        dataOrg.absoluteMaxAlignment = dataMap.getInt(keyPrefix + ElementId.ELEM_ABSOLUTE_MAX_ALIGNMENT.name(), dataOrg.absoluteMaxAlignment);
        dataOrg.machineAlignment = dataMap.getInt(keyPrefix + ElementId.ELEM_MACHINE_ALIGNMENT.name(), dataOrg.machineAlignment);
        dataOrg.defaultAlignment = dataMap.getInt(keyPrefix + ElementId.ELEM_DEFAULT_ALIGNMENT.name(), dataOrg.defaultAlignment);
        dataOrg.defaultPointerAlignment = dataMap.getInt(keyPrefix + ElementId.ELEM_DEFAULT_POINTER_ALIGNMENT.name(), dataOrg.defaultPointerAlignment);
        dataOrg.pointerSize = dataMap.getInt(keyPrefix + ElementId.ELEM_POINTER_SIZE.name(), dataOrg.pointerSize);
        dataOrg.pointerShift = dataMap.getInt(keyPrefix + ElementId.ELEM_POINTER_SHIFT.name(), dataOrg.pointerShift);
        dataOrg.isSignedChar = dataMap.getBoolean(keyPrefix + SIGNED_CHAR_TYPE_NAME, dataOrg.isSignedChar);
        dataOrg.charSize = dataMap.getInt(keyPrefix + ElementId.ELEM_CHAR_SIZE.name(), dataOrg.charSize);
        dataOrg.wideCharSize = dataMap.getInt(keyPrefix + ElementId.ELEM_WCHAR_SIZE.name(), dataOrg.wideCharSize);
        dataOrg.shortSize = dataMap.getInt(keyPrefix + ElementId.ELEM_SHORT_SIZE.name(), dataOrg.shortSize);
        dataOrg.integerSize = dataMap.getInt(keyPrefix + ElementId.ELEM_INTEGER_SIZE.name(), dataOrg.integerSize);
        dataOrg.longSize = dataMap.getInt(keyPrefix + ElementId.ELEM_LONG_SIZE.name(), dataOrg.longSize);
        dataOrg.longLongSize = dataMap.getInt(keyPrefix + ElementId.ELEM_LONG_LONG_SIZE.name(), dataOrg.longLongSize);
        dataOrg.floatSize = dataMap.getInt(keyPrefix + ElementId.ELEM_FLOAT_SIZE.name(), dataOrg.floatSize);
        dataOrg.doubleSize = dataMap.getInt(keyPrefix + ElementId.ELEM_DOUBLE_SIZE.name(), dataOrg.doubleSize);
        dataOrg.longDoubleSize = dataMap.getInt(keyPrefix + ElementId.ELEM_LONG_DOUBLE_SIZE.name(), dataOrg.longDoubleSize);
        boolean firstEntry = true;
        String alignmentMapKeyPrefix = keyPrefix + ElementId.ELEM_SIZE_ALIGNMENT_MAP.name() + ".";
        for (String key : dataMap.keySet()) {
            if (!key.startsWith(alignmentMapKeyPrefix)) continue;
            try {
                int size = Integer.valueOf(key.substring(alignmentMapKeyPrefix.length()));
                int alignment = Integer.valueOf(dataMap.get(key));
                if (firstEntry) {
                    dataOrg.sizeAlignmentMap.clear();
                    firstEntry = false;
                }
                dataOrg.sizeAlignmentMap.put(size, alignment);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        dataOrg.bitFieldPacking = BitFieldPackingImpl.restore(dataMap, keyPrefix + ElementId.ELEM_BITFIELD_PACKING.name() + ".");
        return dataOrg;
    }

    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_DATA_ORGANIZATION);
        if (this.absoluteMaxAlignment != 0) {
            encoder.openElement(ElementId.ELEM_ABSOLUTE_MAX_ALIGNMENT);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.absoluteMaxAlignment);
            encoder.closeElement(ElementId.ELEM_ABSOLUTE_MAX_ALIGNMENT);
        }
        if (this.machineAlignment != 8) {
            encoder.openElement(ElementId.ELEM_MACHINE_ALIGNMENT);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.machineAlignment);
            encoder.closeElement(ElementId.ELEM_MACHINE_ALIGNMENT);
        }
        if (this.defaultAlignment != 1) {
            encoder.openElement(ElementId.ELEM_DEFAULT_ALIGNMENT);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.defaultAlignment);
            encoder.closeElement(ElementId.ELEM_DEFAULT_ALIGNMENT);
        }
        if (this.defaultPointerAlignment != 4) {
            encoder.openElement(ElementId.ELEM_DEFAULT_POINTER_ALIGNMENT);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.defaultPointerAlignment);
            encoder.closeElement(ElementId.ELEM_DEFAULT_POINTER_ALIGNMENT);
        }
        encoder.openElement(ElementId.ELEM_POINTER_SIZE);
        encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.pointerSize);
        encoder.closeElement(ElementId.ELEM_POINTER_SIZE);
        if (this.pointerShift != 0) {
            encoder.openElement(ElementId.ELEM_POINTER_SHIFT);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.pointerShift);
            encoder.closeElement(ElementId.ELEM_POINTER_SHIFT);
        }
        if (!this.isSignedChar) {
            encoder.openElement(ElementId.ELEM_CHAR_TYPE);
            encoder.writeBool(AttributeId.ATTRIB_SIGNED, this.isSignedChar);
            encoder.closeElement(ElementId.ELEM_CHAR_TYPE);
        }
        if (this.charSize != 1) {
            encoder.openElement(ElementId.ELEM_CHAR_SIZE);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.charSize);
            encoder.closeElement(ElementId.ELEM_CHAR_SIZE);
        }
        if (this.wideCharSize != 2) {
            encoder.openElement(ElementId.ELEM_WCHAR_SIZE);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.wideCharSize);
            encoder.closeElement(ElementId.ELEM_WCHAR_SIZE);
        }
        if (this.shortSize != 2) {
            encoder.openElement(ElementId.ELEM_SHORT_SIZE);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.shortSize);
            encoder.closeElement(ElementId.ELEM_SHORT_SIZE);
        }
        if (this.integerSize != 4) {
            encoder.openElement(ElementId.ELEM_INTEGER_SIZE);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.integerSize);
            encoder.closeElement(ElementId.ELEM_INTEGER_SIZE);
        }
        if (this.longSize != 4) {
            encoder.openElement(ElementId.ELEM_LONG_SIZE);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.longSize);
            encoder.closeElement(ElementId.ELEM_LONG_SIZE);
        }
        if (this.longLongSize != 8) {
            encoder.openElement(ElementId.ELEM_LONG_LONG_SIZE);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.longLongSize);
            encoder.closeElement(ElementId.ELEM_LONG_LONG_SIZE);
        }
        if (this.floatSize != 4) {
            encoder.openElement(ElementId.ELEM_FLOAT_SIZE);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.floatSize);
            encoder.closeElement(ElementId.ELEM_FLOAT_SIZE);
        }
        if (this.doubleSize != 8) {
            encoder.openElement(ElementId.ELEM_DOUBLE_SIZE);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.doubleSize);
            encoder.closeElement(ElementId.ELEM_DOUBLE_SIZE);
        }
        if (this.longDoubleSize != 8) {
            encoder.openElement(ElementId.ELEM_LONG_DOUBLE_SIZE);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.longDoubleSize);
            encoder.closeElement(ElementId.ELEM_LONG_DOUBLE_SIZE);
        }
        if (this.sizeAlignmentMap.size() != 0) {
            encoder.openElement(ElementId.ELEM_SIZE_ALIGNMENT_MAP);
            for (int key : this.sizeAlignmentMap.keySet()) {
                encoder.openElement(ElementId.ELEM_ENTRY);
                int value = this.sizeAlignmentMap.get(key);
                encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, key);
                encoder.writeSignedInteger(AttributeId.ATTRIB_ALIGNMENT, value);
                encoder.closeElement(ElementId.ELEM_ENTRY);
            }
            encoder.closeElement(ElementId.ELEM_SIZE_ALIGNMENT_MAP);
        }
        this.bitFieldPacking.encode(encoder);
        encoder.closeElement(ElementId.ELEM_DATA_ORGANIZATION);
    }

    public void restoreXml(XmlPullParser parser) {
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            XmlElement subel;
            String name = parser.peek().getName();
            if (name.equals(ElementId.ELEM_CHAR_TYPE.name())) {
                subel = parser.start(new String[0]);
                String boolStr = subel.getAttribute(AttributeId.ATTRIB_SIGNED.name());
                this.isSignedChar = SpecXmlUtils.decodeBoolean((String)boolStr, (boolean)this.isSignedChar);
                parser.end(subel);
                continue;
            }
            if (name.equals(ElementId.ELEM_BITFIELD_PACKING.name())) {
                this.bitFieldPacking.restoreXml(parser);
                continue;
            }
            if (name.equals(ElementId.ELEM_SIZE_ALIGNMENT_MAP.name())) {
                subel = parser.start(new String[0]);
                while (parser.peek().isStart()) {
                    XmlElement subsubel = parser.start(new String[0]);
                    int size = SpecXmlUtils.decodeInt((String)subsubel.getAttribute(AttributeId.ATTRIB_SIZE.name()));
                    int alignment = SpecXmlUtils.decodeInt((String)subsubel.getAttribute(AttributeId.ATTRIB_ALIGNMENT.name()));
                    this.sizeAlignmentMap.put(size, alignment);
                    parser.end(subsubel);
                }
                parser.end(subel);
                continue;
            }
            subel = parser.start(new String[0]);
            String value = subel.getAttribute(AttributeId.ATTRIB_VALUE.name());
            if (name.equals(ElementId.ELEM_ABSOLUTE_MAX_ALIGNMENT.name())) {
                this.absoluteMaxAlignment = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals(ElementId.ELEM_MACHINE_ALIGNMENT.name())) {
                this.machineAlignment = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals(ElementId.ELEM_DEFAULT_ALIGNMENT.name())) {
                this.defaultAlignment = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals(ElementId.ELEM_DEFAULT_POINTER_ALIGNMENT.name())) {
                this.defaultPointerAlignment = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals(ElementId.ELEM_POINTER_SIZE.name())) {
                this.pointerSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals(ElementId.ELEM_POINTER_SHIFT.name())) {
                this.pointerShift = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals(ElementId.ELEM_CHAR_SIZE.name())) {
                this.charSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals(ElementId.ELEM_WCHAR_SIZE.name())) {
                this.wideCharSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals(ElementId.ELEM_SHORT_SIZE.name())) {
                this.shortSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals(ElementId.ELEM_INTEGER_SIZE.name())) {
                this.integerSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals(ElementId.ELEM_LONG_SIZE.name())) {
                this.longSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals(ElementId.ELEM_LONG_LONG_SIZE.name())) {
                this.longLongSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals(ElementId.ELEM_FLOAT_SIZE.name())) {
                this.floatSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals(ElementId.ELEM_DOUBLE_SIZE.name())) {
                this.doubleSize = SpecXmlUtils.decodeInt((String)value);
            } else if (name.equals(ElementId.ELEM_LONG_DOUBLE_SIZE.name())) {
                this.longDoubleSize = SpecXmlUtils.decodeInt((String)value);
            }
            parser.end(subel);
        }
        parser.end();
    }

    public int hashCode() {
        return Objects.hash(this.absoluteMaxAlignment, this.bigEndian, this.bitFieldPacking, this.charSize, this.defaultAlignment, this.defaultPointerAlignment, this.doubleSize, this.floatSize, this.integerSize, this.isSignedChar, this.longDoubleSize, this.longLongSize, this.longSize, this.machineAlignment, this.pointerShift, this.pointerSize, this.shortSize, this.sizeAlignmentMap, this.wideCharSize);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataOrganizationImpl other = (DataOrganizationImpl)obj;
        return this.absoluteMaxAlignment == other.absoluteMaxAlignment && this.bigEndian == other.bigEndian && Objects.equals(this.bitFieldPacking, other.bitFieldPacking) && this.charSize == other.charSize && this.defaultAlignment == other.defaultAlignment && this.defaultPointerAlignment == other.defaultPointerAlignment && this.doubleSize == other.doubleSize && this.floatSize == other.floatSize && this.integerSize == other.integerSize && this.isSignedChar == other.isSignedChar && this.longDoubleSize == other.longDoubleSize && this.longLongSize == other.longLongSize && this.longSize == other.longSize && this.machineAlignment == other.machineAlignment && this.pointerShift == other.pointerShift && this.pointerSize == other.pointerSize && this.shortSize == other.shortSize && Objects.equals(this.sizeAlignmentMap, other.sizeAlignmentMap) && this.wideCharSize == other.wideCharSize;
    }
}

