/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class ObjectCache<T> {
    private Map<Long, KeyedSoftReference<T>> hashTable;
    private ReferenceQueue<T> refQueue;
    private LinkedList<T> hardCache;
    private int hardCacheSize;

    public ObjectCache(int hardCacheSize) {
        this.hardCacheSize = hardCacheSize;
        this.hashTable = new HashMap<Long, KeyedSoftReference<T>>();
        this.refQueue = new ReferenceQueue();
        this.hardCache = new LinkedList();
    }

    public synchronized boolean contains(long key) {
        this.processQueue();
        return this.hashTable.containsKey(key);
    }

    public synchronized T get(long key) {
        WeakReference ref = this.hashTable.get(key);
        if (ref != null) {
            Object obj = ref.get();
            if (obj == null) {
                this.hashTable.remove(key);
            }
            this.addToHardCache(obj);
            return obj;
        }
        return null;
    }

    public synchronized T computeIfAbsent(long key, Function<Long, T> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        T oldValue = this.get(key);
        if (oldValue != null) {
            return oldValue;
        }
        T newValue = mappingFunction.apply(key);
        if (newValue != null) {
            this.put(key, newValue);
        }
        return newValue;
    }

    public int size() {
        return this.hardCacheSize;
    }

    public synchronized void setHardCacheSize(int size) {
        while (this.hardCache.size() > size) {
            this.hardCache.removeLast();
        }
        this.hardCacheSize = size;
    }

    public synchronized void put(long key, T obj) {
        this.processQueue();
        KeyedSoftReference<T> ref = new KeyedSoftReference<T>(key, obj, this.refQueue);
        this.hashTable.put(key, ref);
        this.addToHardCache(obj);
    }

    public synchronized void remove(long key) {
        this.processQueue();
        KeyedSoftReference<T> ref = this.hashTable.get(key);
        if (ref != null) {
            ref.clear();
            this.hashTable.remove(key);
        }
    }

    private void addToHardCache(T obj) {
        this.hardCache.addLast(obj);
        if (this.hardCache.size() > this.hardCacheSize) {
            this.hardCache.removeFirst();
        }
    }

    private void processQueue() {
        KeyedSoftReference ref;
        while ((ref = (KeyedSoftReference)this.refQueue.poll()) != null) {
            this.hashTable.remove(ref.getKey());
        }
    }

    private static class KeyedSoftReference<T>
    extends WeakReference<T> {
        private long key;

        KeyedSoftReference(long key, T obj, ReferenceQueue<T> queue) {
            super(obj, queue);
            this.key = key;
        }

        long getKey() {
            return this.key;
        }
    }
}

