/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.sublayout;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.sublayout.GraphCollapser;
import org.jungrapht.visualization.sublayout.VisualGraphCollapser;

public interface Collapser<V, E> {
    public V collapse(Collection<V> var1, Function<Collection<V>, V> var2);

    public void expand(Collection<V> var1);

    public void expand(V var1);

    public Function<V, Graph<V, E>> collapsedGraphFunction();

    public Map<V, Graph<V, E>> getCollapsedGraphMap();

    public V findOwnerOf(V var1);

    public static <V, E> Collapser<V, E> forGraph(Graph<V, E> graph) {
        return new GraphCollapser<V, E>(graph);
    }

    public static <V, E> Collapser<V, E> forVisualization(VisualizationServer<V, E> vv) {
        return new VisualGraphCollapser<V, E>(vv);
    }
}

