/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.control.ScalingControl;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossoverScalingControl
implements ScalingControl {
    private static final Logger log = LoggerFactory.getLogger(CrossoverScalingControl.class);
    private static final double RESET_THRESHOLD = 0.002;
    protected boolean bounded;
    protected double minScale;
    protected double maxScale;
    double singleAxisMin;
    double singleAxisMax;
    protected double crossover;
    protected boolean enableSingleAxisScaling;

    public static Builder builder() {
        return new Builder();
    }

    CrossoverScalingControl(Builder builder) {
        this.bounded = builder.bounded;
        this.minScale = builder.minScale;
        this.maxScale = builder.maxScale;
        this.singleAxisMin = this.minScale / 200.0;
        this.singleAxisMax = this.maxScale * 200.0;
        this.crossover = builder.crossover;
        this.enableSingleAxisScaling = builder.enableSingleAxisScaling;
    }

    public CrossoverScalingControl() {
        this(CrossoverScalingControl.builder());
    }

    public void setCrossover(double crossover) {
        this.crossover = crossover;
    }

    public double getCrossover() {
        return this.crossover;
    }

    public void setEnableSingleAxisScaling(boolean enableSingleAxisScaling) {
        this.enableSingleAxisScaling = enableSingleAxisScaling;
    }

    @Override
    public void scale(VisualizationServer<?, ?> vv, double horizontalAmount, double verticalAmount, Point2D at) {
        ScalingControl.Axis axis = !this.enableSingleAxisScaling || horizontalAmount == verticalAmount ? ScalingControl.Axis.XY : (verticalAmount == 1.0 ? ScalingControl.Axis.X : (horizontalAmount == 1.0 ? ScalingControl.Axis.Y : ScalingControl.Axis.XY));
        MutableTransformer layoutTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        MutableTransformer viewTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW);
        double modelScaleX = layoutTransformer.getScaleX();
        double modelScaleY = layoutTransformer.getScaleY();
        double viewScaleX = viewTransformer.getScaleX();
        double viewScaleY = viewTransformer.getScaleY();
        double inverseModelScaleX = Math.sqrt(this.crossover) / modelScaleX;
        double inverseModelScaleY = Math.sqrt(this.crossover) / modelScaleY;
        double inverseViewScaleX = Math.sqrt(this.crossover) / viewScaleX;
        double inverseViewScaleY = Math.sqrt(this.crossover) / viewScaleY;
        double scaleX = modelScaleX * viewScaleX;
        double scaleY = modelScaleY * viewScaleY;
        if (!this.withinScaleBounds(scaleX, scaleY, axis == ScalingControl.Axis.XY ? this.minScale : this.singleAxisMin, axis == ScalingControl.Axis.XY ? this.maxScale : this.singleAxisMax, horizontalAmount, verticalAmount)) {
            log.trace("out of scale bounds: {} {}", (Object)horizontalAmount, (Object)verticalAmount);
            return;
        }
        Point2D transformedAt = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(MultiLayerTransformer.Layer.VIEW, at);
        double newX = scaleX * horizontalAmount;
        double newY = scaleY * verticalAmount;
        double minX = newX - this.crossover;
        double minY = newY - this.crossover;
        log.trace("scaleX: {}, scaleY: {}", (Object)scaleX, (Object)scaleY);
        boolean reset = false;
        if (scaleX == scaleY && minX * minY < 0.002) {
            log.trace("will reset");
            reset = true;
        }
        switch (axis) {
            case X: {
                this.adjustTransformers(horizontalAmount, verticalAmount, at, layoutTransformer, viewTransformer, inverseModelScaleX, inverseModelScaleY, inverseViewScaleX, inverseViewScaleY, transformedAt, reset, newX < this.crossover);
                break;
            }
            case Y: {
                this.adjustTransformers(horizontalAmount, verticalAmount, at, layoutTransformer, viewTransformer, inverseModelScaleX, inverseModelScaleY, inverseViewScaleX, inverseViewScaleY, transformedAt, reset, newY < this.crossover);
                break;
            }
            default: {
                this.adjustTransformers(horizontalAmount, verticalAmount, at, layoutTransformer, viewTransformer, inverseModelScaleX, inverseModelScaleY, inverseViewScaleX, inverseViewScaleY, transformedAt, reset, newX < this.crossover || newY < this.crossover);
            }
        }
        vv.repaint();
    }

    protected void adjustTransformers(double horizontalAmount, double verticalAmount, Point2D at, MutableTransformer layoutTransformer, MutableTransformer viewTransformer, double inverseModelScaleX, double inverseModelScaleY, double inverseViewScaleX, double inverseViewScaleY, Point2D transformedAt, boolean reset, boolean adjustViewTransform) {
        if (reset) {
            log.trace("close to control point horizontalAmount:{}, verticalAmount: {}", (Object)horizontalAmount, (Object)verticalAmount);
            layoutTransformer.scale(inverseModelScaleX, inverseModelScaleY, transformedAt);
            viewTransformer.scale(inverseViewScaleX, inverseViewScaleY, at);
        } else if (adjustViewTransform) {
            log.trace("adjust view {}, {}", (Object)horizontalAmount, (Object)verticalAmount);
            viewTransformer.scale(horizontalAmount, verticalAmount, at);
        } else {
            log.trace("adjust layout {}, {}", (Object)horizontalAmount, (Object)verticalAmount);
            layoutTransformer.scale(horizontalAmount, verticalAmount, transformedAt);
        }
    }

    public void reset(VisualizationServer<?, ?> vv, Point2D at) {
        MutableTransformer layoutTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        MutableTransformer viewTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW);
        double modelScaleX = layoutTransformer.getScaleX();
        double modelScaleY = layoutTransformer.getScaleY();
        double viewScaleX = viewTransformer.getScaleX();
        double viewScaleY = viewTransformer.getScaleY();
        double inverseModelScaleX = Math.sqrt(this.crossover) / modelScaleX;
        double inverseModelScaleY = Math.sqrt(this.crossover) / modelScaleY;
        double inverseViewScaleX = Math.sqrt(this.crossover) / viewScaleX;
        double inverseViewScaleY = Math.sqrt(this.crossover) / viewScaleY;
        Point2D transformedAt = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(MultiLayerTransformer.Layer.VIEW, at);
        layoutTransformer.scale(inverseModelScaleX, inverseModelScaleY, transformedAt);
        viewTransformer.scale(inverseViewScaleX, inverseViewScaleY, at);
    }

    protected boolean withinScaleBounds(double scaleX, double scaleY, double minScale, double maxScale, double horizontalAmount, double verticalAmount) {
        if (!this.bounded) {
            return true;
        }
        if (scaleX > maxScale && horizontalAmount > 1.0) {
            return false;
        }
        if (scaleX < minScale && horizontalAmount < 1.0) {
            return false;
        }
        if (scaleY > maxScale && verticalAmount > 1.0) {
            return false;
        }
        return !(scaleY < minScale) || !(verticalAmount < 1.0);
    }

    public static class Builder {
        boolean bounded;
        double minScale = Double.parseDouble(System.getProperty("jungrapht.minScale", "0.0001"));
        double maxScale = Double.parseDouble(System.getProperty("jungrapht.maxScale", "20000.0"));
        double crossover = Double.parseDouble(System.getProperty("jungrapht.crossover", "1.0"));
        boolean enableSingleAxisScaling = Boolean.parseBoolean(System.getProperty("jungrapht.enableSingleAxisScaling", "true"));

        public Builder bounded(boolean bounded) {
            this.bounded = bounded;
            return this;
        }

        public Builder minScale(double minScale) {
            this.minScale = minScale;
            return this;
        }

        public Builder maxScale(double maxScale) {
            this.maxScale = maxScale;
            return this;
        }

        public Builder crossover(double crossover) {
            this.crossover = crossover;
            return this;
        }

        public Builder enableSingleAxisScaling(boolean enableSingleAxisScaling) {
            this.enableSingleAxisScaling = enableSingleAxisScaling;
            return this;
        }

        public ScalingControl build() {
            return new CrossoverScalingControl(this);
        }
    }
}

