/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.freeplane.view.swing.map.NodeView;

public class NodeViewFolder {
    private final Set<NodeView> unfoldedNodeViews = Collections.newSetFromMap(new WeakHashMap());
    private final boolean unfoldsSingleChildren;

    public NodeViewFolder(boolean unfoldsSingleChildren) {
        this.unfoldsSingleChildren = unfoldsSingleChildren;
    }

    public void foldingWasSet(NodeView view) {
        if (this.unfoldedNodeViews.contains(view)) {
            this.unfoldedNodeViews.remove(view);
        }
    }

    public void reset() {
        this.unfoldedNodeViews.clear();
    }

    public void adjustFolding(Set<NodeView> unfoldNodeViews) {
        HashSet<NodeView> unfoldNodeViewsWithAncestors = this.withAncestors(unfoldNodeViews);
        NodeView[] toFold = (NodeView[])this.unfoldedNodeViews.stream().filter(nodeView -> !unfoldNodeViewsWithAncestors.contains(nodeView) && SwingUtilities.isDescendingFrom(nodeView, nodeView.getMap())).toArray(NodeView[]::new);
        Stream.of(toFold).filter(nodeView -> nodeView.getNode().isFoldable()).forEach(nodeView -> nodeView.setFolded(true));
        if (unfoldNodeViews.isEmpty()) {
            this.unfoldedNodeViews.clear();
        } else {
            unfoldNodeViews.removeAll(Arrays.asList(toFold));
        }
        unfoldNodeViews.stream().forEach(nodeView -> {
            boolean hasUnfoldView = false;
            if (nodeView.isFolded()) {
                nodeView.setFolded(false);
                this.unfoldedNodeViews.add((NodeView)nodeView);
                hasUnfoldView = true;
            }
            if (this.unfoldsSingleChildren) {
                LinkedList<NodeView> childrenViews;
                NodeView descendant = nodeView;
                while ((childrenViews = descendant.getChildrenViews()).size() == 1) {
                    descendant = childrenViews.get(0);
                    if (!descendant.isFolded()) continue;
                    descendant.setFolded(false);
                    if (hasUnfoldView) continue;
                    this.unfoldedNodeViews.add(descendant);
                    hasUnfoldView = true;
                }
            }
        });
    }

    private HashSet<NodeView> withAncestors(Set<NodeView> nodeViews) {
        HashSet<NodeView> withAncestors = new HashSet<NodeView>();
        Iterator<NodeView> iterator = nodeViews.iterator();
        while (iterator.hasNext()) {
            NodeView nodeView;
            for (NodeView ancestor = nodeView = iterator.next(); ancestor != null && !withAncestors.contains(ancestor); ancestor = ancestor.getParentNodeView()) {
                withAncestors.add(ancestor);
            }
        }
        return withAncestors;
    }
}

