﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/customer-profiles/CustomerProfilesRequest.h>
#include <aws/customer-profiles/CustomerProfiles_EXPORTS.h>

#include <utility>

namespace Aws {
namespace CustomerProfiles {
namespace Model {

/**
 */
class DeleteProfileObjectRequest : public CustomerProfilesRequest {
 public:
  AWS_CUSTOMERPROFILES_API DeleteProfileObjectRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteProfileObject"; }

  AWS_CUSTOMERPROFILES_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique identifier of a customer profile.</p>
   */
  inline const Aws::String& GetProfileId() const { return m_profileId; }
  inline bool ProfileIdHasBeenSet() const { return m_profileIdHasBeenSet; }
  template <typename ProfileIdT = Aws::String>
  void SetProfileId(ProfileIdT&& value) {
    m_profileIdHasBeenSet = true;
    m_profileId = std::forward<ProfileIdT>(value);
  }
  template <typename ProfileIdT = Aws::String>
  DeleteProfileObjectRequest& WithProfileId(ProfileIdT&& value) {
    SetProfileId(std::forward<ProfileIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the profile object generated by the service.</p>
   */
  inline const Aws::String& GetProfileObjectUniqueKey() const { return m_profileObjectUniqueKey; }
  inline bool ProfileObjectUniqueKeyHasBeenSet() const { return m_profileObjectUniqueKeyHasBeenSet; }
  template <typename ProfileObjectUniqueKeyT = Aws::String>
  void SetProfileObjectUniqueKey(ProfileObjectUniqueKeyT&& value) {
    m_profileObjectUniqueKeyHasBeenSet = true;
    m_profileObjectUniqueKey = std::forward<ProfileObjectUniqueKeyT>(value);
  }
  template <typename ProfileObjectUniqueKeyT = Aws::String>
  DeleteProfileObjectRequest& WithProfileObjectUniqueKey(ProfileObjectUniqueKeyT&& value) {
    SetProfileObjectUniqueKey(std::forward<ProfileObjectUniqueKeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the profile object type.</p>
   */
  inline const Aws::String& GetObjectTypeName() const { return m_objectTypeName; }
  inline bool ObjectTypeNameHasBeenSet() const { return m_objectTypeNameHasBeenSet; }
  template <typename ObjectTypeNameT = Aws::String>
  void SetObjectTypeName(ObjectTypeNameT&& value) {
    m_objectTypeNameHasBeenSet = true;
    m_objectTypeName = std::forward<ObjectTypeNameT>(value);
  }
  template <typename ObjectTypeNameT = Aws::String>
  DeleteProfileObjectRequest& WithObjectTypeName(ObjectTypeNameT&& value) {
    SetObjectTypeName(std::forward<ObjectTypeNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique name of the domain.</p>
   */
  inline const Aws::String& GetDomainName() const { return m_domainName; }
  inline bool DomainNameHasBeenSet() const { return m_domainNameHasBeenSet; }
  template <typename DomainNameT = Aws::String>
  void SetDomainName(DomainNameT&& value) {
    m_domainNameHasBeenSet = true;
    m_domainName = std::forward<DomainNameT>(value);
  }
  template <typename DomainNameT = Aws::String>
  DeleteProfileObjectRequest& WithDomainName(DomainNameT&& value) {
    SetDomainName(std::forward<DomainNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_profileId;

  Aws::String m_profileObjectUniqueKey;

  Aws::String m_objectTypeName;

  Aws::String m_domainName;
  bool m_profileIdHasBeenSet = false;
  bool m_profileObjectUniqueKeyHasBeenSet = false;
  bool m_objectTypeNameHasBeenSet = false;
  bool m_domainNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace CustomerProfiles
}  // namespace Aws
