/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.cutters.ranges;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.facet.MultiLongValues;
import org.apache.lucene.facet.MultiLongValuesSource;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.sandbox.facet.cutters.FacetCutter;
import org.apache.lucene.sandbox.facet.cutters.LeafFacetCutter;
import org.apache.lucene.sandbox.facet.cutters.ranges.IntervalTracker;
import org.apache.lucene.sandbox.facet.cutters.ranges.NonOverlappingLongRangeFacetCutter;
import org.apache.lucene.sandbox.facet.cutters.ranges.OverlappingLongRangeFacetCutter;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;

public abstract class LongRangeFacetCutter
implements FacetCutter {
    final MultiLongValuesSource valuesSource;
    final LongValuesSource singleValues;
    final LongRangeAndPos[] sortedRanges;
    final int requestedRangeCount;
    final List<InclusiveRange> elementaryIntervals;
    final long[] boundaries;
    final int[] pos;
    static final int SKIP_INTERVAL_POSITION = -1;

    static LongRangeFacetCutter createSingleOrMultiValued(MultiLongValuesSource longValuesSource, LongValuesSource singleLongValuesSource, LongRange[] longRanges) {
        if (LongRangeFacetCutter.areOverlappingRanges(longRanges)) {
            return new OverlappingLongRangeFacetCutter(longValuesSource, singleLongValuesSource, longRanges);
        }
        return new NonOverlappingLongRangeFacetCutter(longValuesSource, singleLongValuesSource, longRanges);
    }

    public static LongRangeFacetCutter create(MultiLongValuesSource longValuesSource, LongRange[] longRanges) {
        return LongRangeFacetCutter.createSingleOrMultiValued(longValuesSource, null, longRanges);
    }

    LongRangeFacetCutter(MultiLongValuesSource longValuesSource, LongValuesSource singleLongValuesSource, LongRange[] longRanges) {
        this.valuesSource = longValuesSource;
        this.singleValues = singleLongValuesSource != null ? singleLongValuesSource : MultiLongValuesSource.unwrapSingleton((MultiLongValuesSource)this.valuesSource);
        this.sortedRanges = new LongRangeAndPos[longRanges.length];
        this.requestedRangeCount = longRanges.length;
        for (int i = 0; i < longRanges.length; ++i) {
            this.sortedRanges[i] = new LongRangeAndPos(longRanges[i], i);
        }
        Arrays.sort(this.sortedRanges, Comparator.comparingLong(r -> r.range.min));
        this.elementaryIntervals = this.buildElementaryIntervals();
        this.boundaries = new long[this.elementaryIntervals.size()];
        this.pos = new int[this.elementaryIntervals.size()];
        Arrays.fill(this.pos, -1);
        int currRange = 0;
        for (int i = 0; i < this.boundaries.length; ++i) {
            this.boundaries[i] = this.elementaryIntervals.get((int)i).end;
            if (currRange >= this.sortedRanges.length) continue;
            LongRangeAndPos curr = this.sortedRanges[currRange];
            if (this.boundaries[i] != curr.range.max) continue;
            this.pos[i] = curr.pos;
            ++currRange;
        }
    }

    abstract List<InclusiveRange> buildElementaryIntervals();

    private static boolean areOverlappingRanges(LongRange[] ranges) {
        if (ranges.length == 0) {
            return false;
        }
        LongRange[] sortedRanges = new LongRange[ranges.length];
        System.arraycopy(ranges, 0, sortedRanges, 0, ranges.length);
        Arrays.sort(sortedRanges, Comparator.comparingLong(r -> r.min));
        long previousMax = sortedRanges[0].max;
        for (int i = 1; i < sortedRanges.length; ++i) {
            if (sortedRanges[i].min <= previousMax) {
                return true;
            }
            previousMax = sortedRanges[i].max;
        }
        return false;
    }

    final class InclusiveRange {
        private final long start;
        private final long end;

        InclusiveRange(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return this.start + " to " + this.end;
        }

        public long start() {
            return this.start;
        }

        public long end() {
            return this.end;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            InclusiveRange that = (InclusiveRange)obj;
            return this.start == that.start && this.end == that.end;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }
    }

    final class LongRangeAndPos {
        private final LongRange range;
        private final int pos;

        LongRangeAndPos(LongRange range, int pos) {
            this.range = range;
            this.pos = pos;
        }

        public String toString() {
            return "LongRangeAndPos[range=" + String.valueOf(this.range) + ", pos=" + this.pos + "]";
        }

        public LongRange range() {
            return this.range;
        }

        public int pos() {
            return this.pos;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            LongRangeAndPos that = (LongRangeAndPos)obj;
            return Objects.equals(this.range, that.range) && this.pos == that.pos;
        }

        public int hashCode() {
            return Objects.hash(this.range, this.pos);
        }
    }

    static abstract class LongRangeSingleValuedLeafFacetCutter
    implements LeafFacetCutter {
        private final LongValues longValues;
        private final long[] boundaries;
        final int[] pos;
        int elementaryIntervalOrd;
        IntervalTracker requestedIntervalTracker;

        LongRangeSingleValuedLeafFacetCutter(LongValues longValues, long[] boundaries, int[] pos) {
            this.longValues = longValues;
            this.boundaries = boundaries;
            this.pos = pos;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            if (!this.longValues.advanceExact(doc)) {
                return false;
            }
            if (this.requestedIntervalTracker != null) {
                this.requestedIntervalTracker.clear();
            }
            this.elementaryIntervalOrd = this.processValue(this.longValues.longValue());
            this.maybeRollUp(this.requestedIntervalTracker);
            if (this.requestedIntervalTracker != null) {
                this.requestedIntervalTracker.freeze();
            }
            return true;
        }

        private int processValue(long v) {
            int mid;
            int lo = 0;
            int hi = this.boundaries.length - 1;
            int lowerBound = lo;
            while (true) {
                if (v <= this.boundaries[mid = lo + hi >>> 1]) {
                    if (mid == lowerBound) {
                        return mid;
                    }
                    hi = mid - 1;
                    continue;
                }
                if (v <= this.boundaries[mid + 1]) break;
                lo = mid + 1;
            }
            return mid + 1;
        }

        void maybeRollUp(IntervalTracker rollUpInto) {
        }
    }

    static abstract class LongRangeMultivaluedLeafFacetCutter
    implements LeafFacetCutter {
        private final MultiLongValues multiLongValues;
        private final long[] boundaries;
        final int[] pos;
        final IntervalTracker elementaryIntervalTracker;
        IntervalTracker requestedIntervalTracker;

        LongRangeMultivaluedLeafFacetCutter(MultiLongValues longValues, long[] boundaries, int[] pos) {
            this.multiLongValues = longValues;
            this.boundaries = boundaries;
            this.pos = pos;
            this.elementaryIntervalTracker = new IntervalTracker.MultiIntervalTracker(boundaries.length);
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            if (!this.multiLongValues.advanceExact(doc)) {
                return false;
            }
            this.elementaryIntervalTracker.clear();
            if (this.requestedIntervalTracker != null) {
                this.requestedIntervalTracker.clear();
            }
            long numValues = this.multiLongValues.getValueCount();
            int lastIntervalSeen = -1;
            int i = 0;
            while ((long)i < numValues) {
                lastIntervalSeen = this.processValue(this.multiLongValues.nextValue(), lastIntervalSeen);
                assert (lastIntervalSeen >= 0 && lastIntervalSeen < this.boundaries.length);
                this.elementaryIntervalTracker.set(lastIntervalSeen);
                if (lastIntervalSeen == this.boundaries.length - 1) break;
                ++i;
            }
            this.maybeRollUp(this.requestedIntervalTracker);
            this.elementaryIntervalTracker.freeze();
            if (this.requestedIntervalTracker != null) {
                this.requestedIntervalTracker.freeze();
            }
            return true;
        }

        private int processValue(long v, int lastIntervalSeen) {
            int mid;
            int lo = 0;
            int hi = this.boundaries.length - 1;
            if (lastIntervalSeen != -1) {
                if (v <= this.boundaries[lastIntervalSeen]) {
                    return lastIntervalSeen;
                }
                lo = lastIntervalSeen + 1;
                if (lo == this.boundaries.length) {
                    return lastIntervalSeen;
                }
            }
            int lowerBound = lo;
            while (true) {
                if (v <= this.boundaries[mid = lo + hi >>> 1]) {
                    if (mid == lowerBound) {
                        return mid;
                    }
                    hi = mid - 1;
                    continue;
                }
                if (v <= this.boundaries[mid + 1]) break;
                lo = mid + 1;
            }
            return mid + 1;
        }

        void maybeRollUp(IntervalTracker rollUpInto) {
        }
    }
}

