/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.base;

import java.io.DataInput;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Path;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.core.io.ContentReference;
import tools.jackson.core.io.IOContext;

public abstract class BinaryTSFactory
extends DecorableTSFactory
implements Serializable {
    private static final long serialVersionUID = 3L;

    protected BinaryTSFactory(StreamReadConstraints src, StreamWriteConstraints swc, ErrorReportConfiguration erc, int formatPF, int formatGF) {
        super(src, swc, erc, formatPF, formatGF);
    }

    protected BinaryTSFactory(DecorableTSFactory.DecorableTSFBuilder<?, ?> baseBuilder) {
        super(baseBuilder);
    }

    protected BinaryTSFactory(BinaryTSFactory src) {
        super(src);
    }

    @Override
    public boolean canHandleBinaryNatively() {
        return true;
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, File f) throws JacksonException {
        InputStream in = this._fileInputStream(f);
        IOContext ioCtxt = this._createContext(this._createContentReference(f), true);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, in));
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, Path p) throws JacksonException {
        IOContext ioCtxt = this._createContext(this._createContentReference(p), true);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, this._pathInputStream(p)));
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, InputStream in) throws JacksonException {
        IOContext ioCtxt = this._createContext(this._createContentReference(in), false);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, in));
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, Reader r) throws JacksonException {
        return (JsonParser)this._nonByteSource();
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, byte[] data, int offset, int len) throws JacksonException {
        InputStream in;
        IOContext ioCtxt = this._createContext(this._createContentReference(data, offset, len), true, null);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ioCtxt, data, offset, len)) != null) {
            return this._createParser(readCtxt, ioCtxt, in);
        }
        return this._createParser(readCtxt, ioCtxt, data, offset, len);
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, String content) throws JacksonException {
        return (JsonParser)this._nonByteSource();
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, char[] content, int offset, int len) throws JacksonException {
        return (JsonParser)this._nonByteSource();
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, DataInput in) throws JacksonException {
        IOContext ioCtxt = this._createContext(this._createContentReference(in), false);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, in));
    }

    protected abstract JsonParser _createParser(ObjectReadContext var1, IOContext var2, InputStream var3) throws JacksonException;

    protected abstract JsonParser _createParser(ObjectReadContext var1, IOContext var2, byte[] var3, int var4, int var5) throws JacksonException;

    protected abstract JsonParser _createParser(ObjectReadContext var1, IOContext var2, DataInput var3) throws JacksonException;

    @Override
    public JsonGenerator createGenerator(ObjectWriteContext writeCtxt, OutputStream out, JsonEncoding enc) throws JacksonException {
        IOContext ioCtxt = this._createContext(this._createContentReference(out), false, enc);
        return this._decorate(this._createGenerator(writeCtxt, ioCtxt, this._decorate(ioCtxt, out)));
    }

    @Override
    public JsonGenerator createGenerator(ObjectWriteContext writeCtxt, Writer w) throws JacksonException {
        return (JsonGenerator)this._nonByteTarget();
    }

    @Override
    public JsonGenerator createGenerator(ObjectWriteContext writeCtxt, File f, JsonEncoding enc) throws JacksonException {
        OutputStream out = this._fileOutputStream(f);
        IOContext ioCtxt = this._createContext(this._createContentReference(out), true, enc);
        return this._decorate(this._createGenerator(writeCtxt, ioCtxt, this._decorate(ioCtxt, out)));
    }

    @Override
    public JsonGenerator createGenerator(ObjectWriteContext writeCtxt, Path p, JsonEncoding enc) throws JacksonException {
        OutputStream out = this._pathOutputStream(p);
        IOContext ioCtxt = this._createContext(this._createContentReference(p), true, enc);
        return this._decorate(this._createGenerator(writeCtxt, ioCtxt, this._decorate(ioCtxt, out)));
    }

    @Override
    protected ContentReference _createContentReference(Object contentRef) {
        return ContentReference.construct(false, contentRef, this._errorReportConfiguration);
    }

    @Override
    protected ContentReference _createContentReference(Object contentRef, int offset, int length) {
        return ContentReference.construct(false, contentRef, offset, length, this._errorReportConfiguration);
    }

    protected abstract JsonGenerator _createGenerator(ObjectWriteContext var1, IOContext var2, OutputStream var3) throws JacksonException;

    protected <T> T _nonByteSource() throws JacksonException {
        throw new UnsupportedOperationException("Cannot create parser for character-based (not byte-based) source");
    }

    protected <T> T _nonByteTarget() throws JacksonException {
        throw new UnsupportedOperationException("Cannot create generator for character-based (not byte-based) target");
    }
}

