/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeSpanStack
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SafeSpanStack.class);
    private final Deque<Span> myStack;
    private final IJTracer myTracer;
    private final Context myUpperContext;

    public SafeSpanStack(@NotNull IJTracer tracer, @Nullable Context upperContext) {
        if (tracer == null) {
            SafeSpanStack.$$$reportNull$$$0(0);
        }
        this.myStack = new ArrayDeque<Span>();
        this.myTracer = tracer;
        this.myUpperContext = upperContext == null ? Context.current() : upperContext;
    }

    @Nullable
    public synchronized Span getCurrentSpan() {
        return this.myStack.peek();
    }

    public synchronized void startSpan(@NotNull String activityName) {
        if (activityName == null) {
            SafeSpanStack.$$$reportNull$$$0(1);
        }
        this.myStack.push(this.myTracer.spanBuilder(activityName).setParent(this.myStack.isEmpty() ? this.myUpperContext : Context.current().with((ImplicitContextKeyed)this.myStack.peek())).startSpan());
    }

    public synchronized void endSpan(@NonNls @Nullable String errDescriptionOrNull) {
        if (this.myStack.isEmpty()) {
            LOG.warn("Lost span start!");
        } else {
            Span span = this.myStack.pop();
            if (errDescriptionOrNull != null) {
                span.setStatus(StatusCode.ERROR, errDescriptionOrNull);
            }
            span.end();
        }
    }

    public synchronized void dispose() {
        while (!this.myStack.isEmpty()) {
            this.endSpan("External span termination!");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/utils/SafeSpanStack";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "startSpan";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

