/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.style.AutomaticCounter;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleLoader;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.style.Value;
import net.sourceforge.plantuml.style.ValueImpl;

public class FromSkinparamToStyle {
    private static final Map<String, List<Data>> knowlegde = new HashMap<String, List<Data>>();
    private final List<Style> styles = new ArrayList<Style>();
    private final String stereo;
    private final String key;

    private static void addMagic(SName sname) {
        String cleanName = sname.name().replace("_", "");
        FromSkinparamToStyle.addConvert(cleanName + "BackgroundColor", PName.BackGroundColor, sname);
        FromSkinparamToStyle.addConvert(cleanName + "BorderColor", PName.LineColor, sname);
        FromSkinparamToStyle.addConvert(cleanName + "BorderThickness", PName.LineThickness, sname);
        FromSkinparamToStyle.addConvert(cleanName + "RoundCorner", PName.RoundCorner, sname);
        FromSkinparamToStyle.addConvert(cleanName + "DiagonalCorner", PName.DiagonalCorner, sname);
        FromSkinparamToStyle.addConvert(cleanName + "BorderStyle", PName.LineStyle, sname);
        FromSkinparamToStyle.addConFont(cleanName, sname);
        FromSkinparamToStyle.addConvert(cleanName + "Shadowing", PName.Shadowing, sname);
        FromSkinparamToStyle.addConvert(cleanName + "StereotypeFontSize", PName.FontSize, SName.stereotype, sname);
        FromSkinparamToStyle.addConvert(cleanName + "StereotypeFontStyle", PName.FontStyle, SName.stereotype, sname);
        FromSkinparamToStyle.addConvert(cleanName + "StereotypeFontColor", PName.FontColor, SName.stereotype, sname);
        FromSkinparamToStyle.addConvert(cleanName + "StereotypeFontName", PName.FontName, SName.stereotype, sname);
    }

    public FromSkinparamToStyle(String key) {
        if (key.contains("<<")) {
            StringTokenizer st = new StringTokenizer(key, "<>");
            this.key = st.nextToken();
            this.stereo = st.hasMoreTokens() ? st.nextToken().trim() : null;
        } else {
            this.key = key;
            this.stereo = null;
        }
    }

    public void convertNow(String value, AutomaticCounter counter) {
        List<Data> datas;
        if (this.key.endsWith("shadowing")) {
            if (value.equalsIgnoreCase("false")) {
                value = "0";
            } else if (value.equalsIgnoreCase("true")) {
                value = "3";
            }
        } else if (this.key.equals("hyperlinkunderline")) {
            if (value.equalsIgnoreCase("false")) {
                value = "0";
            }
            if (value.equalsIgnoreCase("true")) {
                value = "1";
            }
        }
        if (value.equalsIgnoreCase("right:right")) {
            value = "right";
        }
        if (value.equalsIgnoreCase("dotted")) {
            value = "1;3";
        }
        if (value.equalsIgnoreCase("dashed")) {
            value = "7;7";
        }
        if ((datas = knowlegde.get(this.key.toLowerCase())) == null) {
            if (this.key.equalsIgnoreCase("shadowing")) {
                this.addStyle(PName.Shadowing, this.getShadowingValue(value, counter), SName.root);
            } else if (this.key.equalsIgnoreCase("noteshadowing")) {
                this.addStyle(PName.Shadowing, this.getShadowingValue(value, counter), SName.root, SName.note);
            }
            return;
        }
        boolean complex = this.isComplexValue(value);
        if (complex) {
            if (value.contains(";")) {
                if (value.startsWith(";")) {
                    value = " " + value;
                }
                StringTokenizer st = new StringTokenizer(value, ";");
                value = st.nextToken();
                while (st.hasMoreTokens()) {
                    String read = st.nextToken();
                    this.readValue(read, datas, counter);
                }
            } else {
                this.readValue(value, datas, counter);
                return;
            }
        }
        if (!" ".equals(value)) {
            for (Data data : datas) {
                this.addStyle(data.propertyName, ValueImpl.regular(value, counter), data.styleNames);
            }
        }
    }

    private void readValue(String read, List<Data> datas, AutomaticCounter counter) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!read.startsWith("text:")) break block4;
                        String value2 = read.split(":")[1];
                        for (Data data : datas) {
                            this.addStyle(PName.FontColor, ValueImpl.regular(value2, counter), data.styleNames);
                        }
                        break block5;
                    }
                    if (!read.startsWith("line.dotted")) break block6;
                    for (Data data : datas) {
                        this.addStyle(PName.LineStyle, ValueImpl.regular("1;3", counter), data.styleNames);
                    }
                    break block5;
                }
                if (!read.startsWith("line.dashed")) break block7;
                for (Data data : datas) {
                    this.addStyle(PName.LineStyle, ValueImpl.regular("7;7", counter), data.styleNames);
                }
                break block5;
            }
            if (!read.toLowerCase().contains("bold")) break block5;
            for (Data data : datas) {
                this.addStyle(PName.LineThickness, ValueImpl.regular("2", counter), data.styleNames);
            }
        }
    }

    private boolean isComplexValue(String value) {
        if (value.contains(";")) {
            return true;
        }
        return value.startsWith("text:");
    }

    private ValueImpl getShadowingValue(String value, AutomaticCounter counter) {
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
            return ValueImpl.regular("0", counter);
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
            return ValueImpl.regular("3", counter);
        }
        return ValueImpl.regular(value, counter);
    }

    private void addStyle(PName propertyName, Value value, SName ... styleNames) {
        Map<PName, Value> map = new EnumMap<PName, Value>(PName.class);
        map.put(propertyName, value);
        StyleSignatureBasic sig = StyleSignatureBasic.of(styleNames);
        if (this.stereo != null) {
            map = StyleLoader.addPriorityForStereotype(map);
            for (String s : this.stereo.split("\\&")) {
                sig = sig.addStereotype(s);
            }
        }
        Style style = new Style(sig, map);
        this.styles.add(style);
    }

    public List<Style> getStyles() {
        return Collections.unmodifiableList(this.styles);
    }

    private static void addConvert(String skinparam, PName propertyName, SName ... styleNames) {
        List<Data> datas = knowlegde.get(skinparam = skinparam.toLowerCase());
        if (datas == null) {
            datas = new ArrayList<Data>();
            knowlegde.put(skinparam, datas);
        }
        datas.add(new Data(styleNames, propertyName));
    }

    private static void addConFont(String skinparam, SName ... styleNames) {
        FromSkinparamToStyle.addConvert(skinparam + "FontSize", PName.FontSize, styleNames);
        FromSkinparamToStyle.addConvert(skinparam + "FontStyle", PName.FontStyle, styleNames);
        FromSkinparamToStyle.addConvert(skinparam + "FontColor", PName.FontColor, styleNames);
        FromSkinparamToStyle.addConvert(skinparam + "FontName", PName.FontName, styleNames);
    }

    static {
        FromSkinparamToStyle.addConvert("participantClickableBackgroundColor", PName.BackGroundColor, SName.participant, SName.clickable);
        FromSkinparamToStyle.addConvert("participantClickableBorderColor", PName.LineColor, SName.participant, SName.clickable);
        FromSkinparamToStyle.addMagic(SName.participant);
        FromSkinparamToStyle.addMagic(SName.boundary);
        FromSkinparamToStyle.addMagic(SName.control);
        FromSkinparamToStyle.addMagic(SName.collections);
        FromSkinparamToStyle.addMagic(SName.actor);
        FromSkinparamToStyle.addMagic(SName.database);
        FromSkinparamToStyle.addMagic(SName.entity);
        FromSkinparamToStyle.addConFont("header", SName.document, SName.header);
        FromSkinparamToStyle.addConFont("footer", SName.document, SName.footer);
        FromSkinparamToStyle.addConFont("caption", SName.document, SName.caption);
        FromSkinparamToStyle.addConvert("defaultFontSize", PName.FontSize, SName.element);
        FromSkinparamToStyle.addConvert("sequenceStereotypeFontSize", PName.FontSize, SName.stereotype);
        FromSkinparamToStyle.addConvert("sequenceStereotypeFontStyle", PName.FontStyle, SName.stereotype);
        FromSkinparamToStyle.addConvert("sequenceStereotypeFontColor", PName.FontColor, SName.stereotype);
        FromSkinparamToStyle.addConvert("sequenceStereotypeFontName", PName.FontName, SName.stereotype);
        FromSkinparamToStyle.addConvert("SequenceReferenceBorderColor", PName.LineColor, SName.reference);
        FromSkinparamToStyle.addConvert("SequenceReferenceBorderColor", PName.LineColor, SName.referenceHeader);
        FromSkinparamToStyle.addConvert("SequenceReferenceBackgroundColor", PName.BackGroundColor, SName.reference);
        FromSkinparamToStyle.addConvert("sequenceReferenceHeaderBackgroundColor", PName.BackGroundColor, SName.referenceHeader);
        FromSkinparamToStyle.addConFont("sequenceReference", SName.reference);
        FromSkinparamToStyle.addConFont("sequenceReference", SName.referenceHeader);
        FromSkinparamToStyle.addConvert("sequenceGroupBorderThickness", PName.LineThickness, SName.group);
        FromSkinparamToStyle.addConvert("SequenceGroupBorderColor", PName.LineColor, SName.group);
        FromSkinparamToStyle.addConvert("SequenceGroupBorderColor", PName.LineColor, SName.groupHeader);
        FromSkinparamToStyle.addConvert("SequenceGroupBackgroundColor", PName.BackGroundColor, SName.groupHeader);
        FromSkinparamToStyle.addConFont("SequenceGroup", SName.group);
        FromSkinparamToStyle.addConFont("SequenceGroupHeader", SName.groupHeader);
        FromSkinparamToStyle.addConvert("SequenceBoxBorderColor", PName.LineColor, SName.box);
        FromSkinparamToStyle.addConvert("SequenceBoxBackgroundColor", PName.BackGroundColor, SName.box);
        FromSkinparamToStyle.addConvert("SequenceBoxFontColor", PName.FontColor, SName.box);
        FromSkinparamToStyle.addConvert("SequenceLifeLineBorderColor", PName.LineColor, SName.lifeLine);
        FromSkinparamToStyle.addConvert("SequenceLifeLineBackgroundColor", PName.BackGroundColor, SName.activationBox);
        FromSkinparamToStyle.addConFont("sequenceDelay", SName.delay);
        FromSkinparamToStyle.addConvert("sequenceDelayBorderColor", PName.LineColor, SName.delay);
        FromSkinparamToStyle.addConvert("sequenceDividerBackgroundColor", PName.BackGroundColor, SName.separator);
        FromSkinparamToStyle.addConvert("sequenceDividerBorderColor", PName.LineColor, SName.separator);
        FromSkinparamToStyle.addConFont("sequenceDivider", SName.separator);
        FromSkinparamToStyle.addConvert("sequenceDividerBorderThickness", PName.LineThickness, SName.separator);
        FromSkinparamToStyle.addConvert("SequenceMessageAlignment", PName.HorizontalAlignment, SName.arrow);
        FromSkinparamToStyle.addConFont("note", SName.note);
        FromSkinparamToStyle.addConvert("noteBorderThickness", PName.LineThickness, SName.note);
        FromSkinparamToStyle.addConvert("noteBorderColor", PName.LineColor, SName.note);
        FromSkinparamToStyle.addConvert("noteBackgroundColor", PName.BackGroundColor, SName.note);
        FromSkinparamToStyle.addConvert("packageBackgroundColor", PName.BackGroundColor, SName.group);
        FromSkinparamToStyle.addConvert("packageBorderColor", PName.LineColor, SName.group);
        FromSkinparamToStyle.addMagic(SName.package_);
        FromSkinparamToStyle.addConvert("PartitionBorderColor", PName.LineColor, SName.composite);
        FromSkinparamToStyle.addConvert("PartitionBackgroundColor", PName.BackGroundColor, SName.composite);
        FromSkinparamToStyle.addConFont("Partition", SName.composite);
        FromSkinparamToStyle.addConvert("hyperlinkColor", PName.HyperLinkColor, SName.root);
        FromSkinparamToStyle.addConvert("activityStartColor", PName.BackGroundColor, SName.circle, SName.start);
        FromSkinparamToStyle.addConvert("activityEndColor", PName.LineColor, SName.circle, SName.end);
        FromSkinparamToStyle.addConvert("activityStopColor", PName.LineColor, SName.circle, SName.stop);
        FromSkinparamToStyle.addConvert("activityBarColor", PName.BackGroundColor, SName.activityBar);
        FromSkinparamToStyle.addConvert("activityBorderColor", PName.LineColor, SName.activity);
        FromSkinparamToStyle.addConvert("activityBorderThickness", PName.LineThickness, SName.activity);
        FromSkinparamToStyle.addConvert("activityBackgroundColor", PName.BackGroundColor, SName.activity);
        FromSkinparamToStyle.addConFont("activity", SName.activity);
        FromSkinparamToStyle.addConvert("activityDiamondBackgroundColor", PName.BackGroundColor, SName.diamond);
        FromSkinparamToStyle.addConvert("activityDiamondBorderColor", PName.LineColor, SName.diamond);
        FromSkinparamToStyle.addConFont("activityDiamond", SName.diamond);
        FromSkinparamToStyle.addConFont("arrow", SName.arrow);
        FromSkinparamToStyle.addConvert("arrowThickness", PName.LineThickness, SName.arrow);
        FromSkinparamToStyle.addConvert("arrowColor", PName.LineColor, SName.arrow);
        FromSkinparamToStyle.addConvert("arrowStyle", PName.LineStyle, SName.arrow);
        FromSkinparamToStyle.addConvert("arrowHeadColor", PName.HeadColor, SName.arrow);
        FromSkinparamToStyle.addConvert("defaulttextalignment", PName.HorizontalAlignment, SName.root);
        FromSkinparamToStyle.addConvert("defaultFontName", PName.FontName, SName.root);
        FromSkinparamToStyle.addConvert("defaultFontColor", PName.FontColor, SName.root);
        FromSkinparamToStyle.addConFont("SwimlaneTitle", SName.swimlane);
        FromSkinparamToStyle.addConvert("SwimlaneTitleBackgroundColor", PName.BackGroundColor, SName.swimlane);
        FromSkinparamToStyle.addConvert("SwimlaneBorderColor", PName.LineColor, SName.swimlane);
        FromSkinparamToStyle.addConvert("SwimlaneBorderThickness", PName.LineThickness, SName.swimlane);
        FromSkinparamToStyle.addConvert("roundCorner", PName.RoundCorner, SName.root);
        FromSkinparamToStyle.addConvert("titleBorderThickness", PName.LineThickness, SName.title);
        FromSkinparamToStyle.addConvert("titleBorderColor", PName.LineColor, SName.title);
        FromSkinparamToStyle.addConvert("titleBackgroundColor", PName.BackGroundColor, SName.title);
        FromSkinparamToStyle.addConvert("titleBorderRoundCorner", PName.RoundCorner, SName.title);
        FromSkinparamToStyle.addConFont("title", SName.document, SName.title);
        FromSkinparamToStyle.addConvert("legendBorderThickness", PName.LineThickness, SName.legend);
        FromSkinparamToStyle.addConvert("legendBorderColor", PName.LineColor, SName.legend);
        FromSkinparamToStyle.addConvert("legendBackgroundColor", PName.BackGroundColor, SName.legend);
        FromSkinparamToStyle.addConvert("legendBorderRoundCorner", PName.RoundCorner, SName.legend);
        FromSkinparamToStyle.addConFont("legend", SName.legend);
        FromSkinparamToStyle.addConvert("noteTextAlignment", PName.HorizontalAlignment, SName.note);
        FromSkinparamToStyle.addConvert("BackgroundColor", PName.BackGroundColor, SName.document);
        FromSkinparamToStyle.addConvert("classBackgroundColor", PName.BackGroundColor, SName.element, SName.class_);
        FromSkinparamToStyle.addConvert("classBorderColor", PName.LineColor, SName.element, SName.class_);
        FromSkinparamToStyle.addConvert("classFontSize", PName.FontSize, SName.element, SName.class_, SName.header);
        FromSkinparamToStyle.addConvert("classFontStyle", PName.FontStyle, SName.element, SName.class_, SName.header);
        FromSkinparamToStyle.addConvert("classFontColor", PName.FontColor, SName.element, SName.class_, SName.header);
        FromSkinparamToStyle.addConvert("classFontName", PName.FontName, SName.element, SName.class_, SName.header);
        FromSkinparamToStyle.addConvert("classAttributeFontSize", PName.FontSize, SName.element, SName.class_);
        FromSkinparamToStyle.addConvert("classAttributeFontStyle", PName.FontStyle, SName.element, SName.class_);
        FromSkinparamToStyle.addConvert("classAttributeFontColor", PName.FontColor, SName.element, SName.class_);
        FromSkinparamToStyle.addConvert("classAttributeFontName", PName.FontName, SName.element, SName.class_);
        FromSkinparamToStyle.addConvert("classBorderThickness", PName.LineThickness, SName.element, SName.class_);
        FromSkinparamToStyle.addConvert("classHeaderBackgroundColor", PName.BackGroundColor, SName.element, SName.class_, SName.header);
        FromSkinparamToStyle.addConvert("objectBackgroundColor", PName.BackGroundColor, SName.object);
        FromSkinparamToStyle.addConvert("objectBorderColor", PName.LineColor, SName.object);
        FromSkinparamToStyle.addConFont("object", SName.object);
        FromSkinparamToStyle.addConFont("objectAttribute", SName.object);
        FromSkinparamToStyle.addConvert("objectBorderThickness", PName.LineThickness, SName.object);
        FromSkinparamToStyle.addConvert("stateBackgroundColor", PName.BackGroundColor, SName.state);
        FromSkinparamToStyle.addConvert("stateBorderColor", PName.LineColor, SName.state);
        FromSkinparamToStyle.addConFont("state", SName.state);
        FromSkinparamToStyle.addConFont("stateAttribute", SName.state);
        FromSkinparamToStyle.addConvert("stateBorderThickness", PName.LineThickness, SName.state);
        FromSkinparamToStyle.addMagic(SName.agent);
        FromSkinparamToStyle.addMagic(SName.artifact);
        FromSkinparamToStyle.addMagic(SName.card);
        FromSkinparamToStyle.addMagic(SName.interface_);
        FromSkinparamToStyle.addMagic(SName.cloud);
        FromSkinparamToStyle.addMagic(SName.component);
        FromSkinparamToStyle.addMagic(SName.file);
        FromSkinparamToStyle.addMagic(SName.folder);
        FromSkinparamToStyle.addMagic(SName.frame);
        FromSkinparamToStyle.addMagic(SName.hexagon);
        FromSkinparamToStyle.addMagic(SName.node);
        FromSkinparamToStyle.addMagic(SName.person);
        FromSkinparamToStyle.addMagic(SName.queue);
        FromSkinparamToStyle.addMagic(SName.rectangle);
        FromSkinparamToStyle.addMagic(SName.stack);
        FromSkinparamToStyle.addMagic(SName.storage);
        FromSkinparamToStyle.addMagic(SName.usecase);
        FromSkinparamToStyle.addMagic(SName.map);
        FromSkinparamToStyle.addMagic(SName.archimate);
        FromSkinparamToStyle.addMagic(SName.hnote);
        FromSkinparamToStyle.addMagic(SName.rnote);
        FromSkinparamToStyle.addConvert("IconPrivateColor", PName.LineColor, SName.visibilityIcon, SName.private_);
        FromSkinparamToStyle.addConvert("IconPrivateBackgroundColor", PName.BackGroundColor, SName.visibilityIcon, SName.private_);
        FromSkinparamToStyle.addConvert("IconPackageColor", PName.LineColor, SName.visibilityIcon, SName.package_);
        FromSkinparamToStyle.addConvert("IconPackageBackgroundColor", PName.BackGroundColor, SName.visibilityIcon, SName.package_);
        FromSkinparamToStyle.addConvert("IconProtectedColor", PName.LineColor, SName.visibilityIcon, SName.protected_);
        FromSkinparamToStyle.addConvert("IconProtectedBackgroundColor", PName.BackGroundColor, SName.visibilityIcon, SName.protected_);
        FromSkinparamToStyle.addConvert("IconPublicColor", PName.LineColor, SName.visibilityIcon, SName.public_);
        FromSkinparamToStyle.addConvert("IconPublicBackgroundColor", PName.BackGroundColor, SName.visibilityIcon, SName.public_);
        FromSkinparamToStyle.addConvert("MinClassWidth", PName.MinimumWidth, new SName[0]);
        FromSkinparamToStyle.addConvert("wrapWidth", PName.MaximumWidth, SName.element);
        FromSkinparamToStyle.addConvert("HyperlinkUnderline", PName.HyperlinkUnderlineThickness, SName.element);
        FromSkinparamToStyle.addConvert("StereotypeAlignment", PName.HorizontalAlignment, SName.stereotype);
        FromSkinparamToStyle.addConvert("stereotypeABackgroundColor", PName.BackGroundColor, SName.spotAbstractClass);
        FromSkinparamToStyle.addConvert("stereotypeABorderColor", PName.LineColor, SName.spotAbstractClass);
        FromSkinparamToStyle.addConvert("stereotypeCBackgroundColor", PName.BackGroundColor, SName.spotClass);
        FromSkinparamToStyle.addConvert("stereotypeCBorderColor", PName.LineColor, SName.spotClass);
        FromSkinparamToStyle.addConvert("stereotypeEBackgroundColor", PName.BackGroundColor, SName.spotEnum);
        FromSkinparamToStyle.addConvert("stereotypeEBorderColor", PName.LineColor, SName.spotEnum);
        FromSkinparamToStyle.addConvert("stereotypeIBackgroundColor", PName.BackGroundColor, SName.spotInterface);
        FromSkinparamToStyle.addConvert("stereotypeIBorderColor", PName.LineColor, SName.spotInterface);
        FromSkinparamToStyle.addConvert("stereotypeNBackgroundColor", PName.BackGroundColor, SName.spotAnnotation);
        FromSkinparamToStyle.addConvert("stereotypeNBorderColor", PName.LineColor, SName.spotAnnotation);
    }

    static class Data {
        private final SName[] styleNames;
        private final PName propertyName;

        Data(SName[] styleNames, PName propertyName) {
            this.propertyName = propertyName;
            this.styleNames = styleNames;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (SName s : this.styleNames) {
                sb.append(s.toString());
                sb.append(".");
            }
            sb.setLength(sb.length() - 1);
            sb.append("]");
            sb.append(this.propertyName.toString());
            return sb.toString();
        }
    }
}

